<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: transformation.inc,v 1.5 2007/12/21 14:58:37 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once($GLOBALS["TMAPY_LIB"]."/matkart/transform_fce.inc");

function TransformBBOX_For_TMS($coordsys_from,$coordsys_to,$extent=false) {

  if ($coordsys_from && $coordsys_to && ($coordsys_from != $coordsys_to)) {
    $points = array();
    $points[0] = Transform_For_TMS($coordsys_from, $coordsys_to, $extent["minx"], $extent["miny"]);  
    $points[1] = Transform_For_TMS($coordsys_from, $coordsys_to, $extent["minx"], $extent["maxy"]);  
    $points[2] = Transform_For_TMS($coordsys_from, $coordsys_to, $extent["maxx"], $extent["maxy"]);  
    $points[3] = Transform_For_TMS($coordsys_from, $coordsys_to, $extent["maxx"], $extent["miny"]);
    $extent = array();
    foreach ($points as $pt) {
      if (!isset($extent['minx']) || $extent['minx'] > $pt['x']) $extent['minx'] = $pt['x']; 
      if (!isset($extent['maxx']) || $extent['maxx'] < $pt['x']) $extent['maxx'] = $pt['x']; 
      if (!isset($extent['miny']) || $extent['miny'] > $pt['y']) $extent['miny'] = $pt['y']; 
      if (!isset($extent['maxy']) || $extent['maxy'] < $pt['y']) $extent['maxy'] = $pt['y']; 
    }
  }
  return $extent;
}

function Transform_For_TMS($coordsys_from,$coordsys_to,$x,$y) {
  $result = false;
  if ($coordsys_from && $coordsys_to && ($coordsys_from != $coordsys_to)) {
    if (preg_match('/^epsg:/', $coordsys_from) && preg_match('/^epsg:/', $coordsys_to)) {
      if (!function_exists('ms_newPointObj')) {
        dl('php_mapscript462_basic.so');
      }
      $ptobj = ms_newPointObj();
      $p_from = ms_newprojectionobj("init=".$coordsys_from);
      $p_to = ms_newprojectionobj("init=".$coordsys_to);
      @$ptobj->setXY($x,$y);
      if (@$ptobj->project($p_from, $p_to) == MS_SUCCESS) {
        $result["x"] = $ptobj->x;
        $result["y"] = $ptobj->y;
      }
    } else {
      switch ($coordsys_from) {
        case "WGS84":
          $x1 = degtorad($x);
          $y1 = degtorad($y);
        break;
        default:
          $x1 = $x;
          $y1 = $y;
      }
      $coorditem = Transform($coordsys_from, $coordsys_to, $x1, $y1);
      if (!$coorditem) {
        echo ("Cannot convert coordinates from \"$coordsys_from\" to \"$coordsys_to\" (X=$x, Y=$y).");
      } else {
        switch ($coordsys_to) {
          case "S42":
            $x = $coorditem["x"];
            $result["x"] = $coorditem["y"];
            $result["y"] = $x;
          break;
          case "WGS84":
            $result["x"] = radtodeg($coorditem["y"]);
            $result["y"] = radtodeg($coorditem["x"]);
          break;
          default:
            $result = $coorditem;
          break;
        }
      }
    }
  } else {
    $result["x"] = $x;
    $result["y"] = $y;
  }
  return $result; 
}


function Transform($odkud,$kam,$x,$y,$params=false) {
  $system=getcoordsys($y,$x);
  if ($system == 0) {
    $system=getcoordsys($x,$y);
    if ($system <> 0) {$a=$x;$x=$y;$y=$a;}
  }

  switch($odkud) {
    case "S42":
      switch($kam) {
        case "SJTSK":
          $x42=$x;
          $y42=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/s42sjtsk.inc");
          $result["x"]=$s42sjtsk["x"];
          $result["y"]=$s42sjtsk["y"]; 
        break;
        case "WGS84":
          $x42=$x;
          $y42=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/s42wgs84.inc");
          $result["x"]=$s42wgs84["fi"];
          $result["y"]=$s42wgs84["lambda"];
        break;
        case "UTMCZ":          
        case "UTM":
          $x42=$x;
          $y42=$y;
          $utm = s42utm($y42,$x42);
          $result["x"]=round($utm["x"],3);
          $result["y"]=round($utm["y"],3);
        break;
        case "S42":
          $result["x"]=$x;
          $result["y"]=$y;
        break;
      }
    break;
    case "SJTSK":
      switch($kam) {
        case "S42":
          $xjtsk=$x;
          $yjtsk=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/sjtsks42.inc");
          $result["x"]=$sjtsk["x"];
          $result["y"]=$sjtsk["y"];
        break;
        case "WGS84":
          $xjtsk=abs($x);
          $yjtsk=abs($y);
		      include($GLOBALS["TMAPY_LIB"]."/matkart/sjtsks42.inc");
          include($GLOBALS["TMAPY_LIB"]."/matkart/sjtskwgs84.inc");
          $result["x"]=round($wgs84["fi"],5);
      	  $result["y"]=round($wgs84["lambda"],5);
        break;
        case "UTMCZ":          
        case "UTM":
          $xjtsk=$x;
          $yjtsk=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/sjtsks42.inc");
          $utm = s42utm($sjtsk["x"],$sjtsk["y"]);
          $result["x"]=round($utm["y"],2);
      	  $result["y"]=round($utm["x"],2);
        break;
        case "SJTSK":
          $result["x"]=$x;
          $result["y"]=$y;
        break;
      }
    break;
    case "WGS84":
      switch($kam) {
        case "S42":
          $bwgs84=$x;
      	  $lwgs84=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/wgs84s42.inc");
          $result["x"]=$wgs84s42["x"];
      	  $result["y"]=$wgs84s42["y"];
        break;
        case "SJTSK":
          $bwgs84=$x;
      	  $lwgs84=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/wgs84sjtsk.inc");
          $result["x"]=$wgs84sjtsk["x"];
      	  $result["y"]=$wgs84sjtsk["y"];
        break;
        case "UTM":
          include_once($GLOBALS["TMAPY_LIB"]."/matkart/lltoutm.inc");
          $result = fltoutm($x, $y, $params);
        break;
        case "UTMCZ":
          $result["x"] -= 250000;
          $bwgs84=$x;
      	  $lwgs84=$y;
          include($GLOBALS["TMAPY_LIB"]."/matkart/wgs84s42.inc");
          $utm = s42utm($wgs84s42["x"],$wgs84s42["y"]);
          $result["x"]=round($utm["y"],2);
          $result["y"]=round($utm["x"],2);
        break;
        case "WGS84":
          $result["x"]=$x;
          $result["y"]=$y;
        break;
      }
    break;
    case "UTM":          
    case "UTMCZ":          
      $utm = utms42($y,$x);
      $x42=$utm["y"];
      $y42=$utm["x"];
      switch($kam) {
        case "S42":
          $result["x"]=round($x42,2);
      	  $result["y"]=round($y42,2);
        break;
        case "SJTSK":
      	  include($GLOBALS["TMAPY_LIB"]."/matkart/s42sjtsk.inc");
       	  $result["x"]=$s42sjtsk["x"];
      	  $result["y"]=$s42sjtsk["y"];
        break;
        case "WGS84":
          if ($kam == "UTMCZ") {          
            include($GLOBALS["TMAPY_LIB"]."/matkart/s42wgs84.inc");
            $result["fi_cis"]=round($s42wgs84["fi"],5);
        	  $result["la_cis"]=round($s42wgs84["lambda"],5); 
          } else {
            include_once($GLOBALS["TMAPY_LIB"]."/matkart/lltoutm.inc");
            $result = utmtofl($x, $y, $params);
          }
        break;
        case "UTMCZ":          
        case "UTM":
          $result["x"]=$x;
          $result["y"]=$y;
        break;
      }
    break;
  }
return($result);
}
?>
