<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: transform_fce.inc,v 1.2 2002/11/11 15:22:54 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

function getcoordsys($x,$y) {
      $result=0;
      if (($y < -930000) && ($y > -1350000) && ($x < -150000) && ($x > -930000)) $result=1; //sjtsk
			if ((-$y < -930000) && (-$y > -1350000) && (-$x < -150000) && (-$x > -930000)) $result=1; //-sjtsk
      if (($x > 2000000) && ($x < 5000000) && ($y > 4000000) && ($x < 7000000)) $result=2;  //s42
			if ((-$x > 2000000) && (-$x < 5000000) && (-$y > 4000000) && (-$x < 7000000)) $result=2;  //s42
      if (($x > -360) && ($x < 360) && ($y > -90) && ($x < 90)) $result=3;                  //wgs84
			if (($x > 150000) && ($x < 930000) && ($y > 150000) && ($y < 7000000)) $result=4;
			return($result);
}

function mocni($zaklad,$exponent){
      return(exp($exponent*log($zaklad)));
}

function decrad($uhel) {
      $ro   = 57.295779513082321;
      return($uhel/$ro);
}	 

function raddms ($radiany) {
      $ro   = 57.295779513082321;
      $stupne=$radiany*$ro;
      $minuty=($stupne-intval($stupne))*60;
      $vteriny=($minuty-intval($minuty))*60;
      $stupne=intval($stupne);
      $minuty=intval($minuty);
      if ($vteriny>59.99999 ){$vteriny=0; $minuty=$minuty+1;} 
      if ($minuty==60){$minuty=0; $stupne=$stupne+1;}
      if ($stupne==360) $stupne=0;
      if ($stupne>360) $stupne=$stupne-360;
          
		  $raddms["stupne"]=$stupne;
		  $raddms["minuty"]=$minuty;
		  $raddms["vteriny"]=$vteriny;

     return ($raddms);
}
		
function dmsrad ($stupne,$minuty,$vteriny) {
      $ro   = 57.295779513082321;
      return(($stupne+$minuty/60+$vteriny/3600)/$ro);
}

function decdms ($uhel) {
      $stupne=($uhel);
      $minuty=($stupne-intval($stupne))*60;
      $vteriny=($minuty-intval($minuty))*60;
      $stupne=intval($stupne);
      $minuty=intval($minuty);
      if ($vteriny > 59.99999){ $vteriny=0; $minuty=$minuty+1; }
      if ($minuty == 60) {$minuty=0;  $stupne=$stupne+1; }
      if ($stupne == 360) $stupne=0;
			
			$decdms["stupne"]=$stupne;
				$decdms["minuty"]=$minuty;
					$decdms["vteriny"]=$vteriny;
			return($decdms);		
}

function dmsdec ($stupne,$minuty,$vteriny) {
               return($stupne+$minuty/60+$vteriny/3600);
}

function degtorad($deg) {
 $pi = 3.1415926535897932384626433832795;
 return ($deg / 180.0 * $pi);
}

function radtodeg($rad) {
 $pi = 3.1415926535897932384626433832795;
 return ($rad / $pi * 180.0);
}
  
function xytest($xjtsk,$yjtsk) {
		  $itest=0;
		  if (($xjtsk>1350000) || ($xjtsk<930000)) $itest=1;  
			if (($yjtsk> 930000) || ($yjtsk<150000)) $itest=1;
			return($itest);
}

function xyjtsk42all($xjtsk,$yjtsk) {
  	$ro = 57.295779513082321;
  	$grfek = 17.6666666667;
	     $krovak_xyfl=krovakxyfl($xjtsk,$yjtsk);
       $jtsks42_dbdl=jtsks42dbdl($xjtsk,$yjtsk);
       $b42=$krovak_xyfl["fi"]+$jtsks42_dbdl["db"];
       $l42=$krovak_xyfl["lambdaf"]-$grfek/$ro+$jtsks42_dbdl["dl"];
       $pas=lpas($l42);
       $gauss_blxy=gaussblxy($b42,$l42,$pas);
       $lambdag=$krovak_xyfl["lambdaf"]-$grfek/$ro;
 
			 $xyjtsk42all["b42"]=$b42;
			 $xyjtsk42all["l42"]=$l42;
			 $xyjtsk42all["pas"]=$pas;
			 $xyjtsk42all["gama42"]=$gauss_blxy["gama"];
			 $xyjtsk42all["m42"]=$gauss_blxy["m"];
			 $xyjtsk42all["x42"]=$gauss_blxy["x"];
			 $xyjtsk42all["y42"]=$gauss_blxy["y"];
			 $xyjtsk42all["fi"]=$krovak_xyfl["fi"];
			 $xyjtsk42all["lambdaf"]=$krovak_xyfl["lambdaf"];
			 $xyjtsk42all["lambdag"]=$lambdag;
			 $xyjtsk42all["c"]=$krovak_xyfl["c"];
       $xyjtsk42all["mjtsk"]=$krovak_xyfl["mjtsk"];
		 
			 return	($xyjtsk42all);	
}
	
function gaussblxy($b,$l,$pas) {
    $ro = 57.295779513082321;
		

    $a=6378245; $c=6356863.019;
    $e22=0.673852541468/100; $ee=0.669342162297/100;
    $e21=0.0066934216;

    $lnula=$pas*6-3;
    $ll=($l-$lnula/$ro);
    $f2=$b*2;    $f4=$b*4;    $f6=$b*6;     $f8=$b*8;
    $bpruh=111134.861084*$b*$ro-16036.480269*sin($f2)+
           16.828067*sin($f4)-0.021975*sin($f6)
             +0.000031*sin($f8);
    $t=sin($b )/cos($b );
    $eta2=$e22*cos($b )*cos($b );
    $n=$a/sqrt(1-$e21*sin($b )*sin($b ));

    $x=$bpruh+$n*sin($b )*cos($b )*($ll*$ll/2);
    $x=$x+$n*sin($b )*cos($b )*cos($b )*cos($b )
      *(5-$t*$t+9*$eta2+4*$eta2*$eta2)*($ll*$ll*$ll*$ll/24);

    $y=$n*cos($b )*$ll;
    $y=$y+$n*cos($b )*cos($b )*cos($b )*(1-$t*$t+$eta2)*($ll*$ll*$ll/6);
    $y=$y+$n*cos($b )*cos($b )*cos($b )*cos($b )*cos($b )*
       (5-18*$t*$t+$t*$t*$t*$t+14*$eta2-58*$eta2*$t*$t)*
       ($ll*$ll*$ll*$ll*$ll/120);
    $y=$y+500000+$pas*1000000;

    $m=1+ cos($b)*cos($b)*(1+$eta2)*$ll*$ll/2+
       cos($b)*cos($b)*cos($b)*cos($b)*
       (5-4*$t*$t)*$ll*$ll*$ll*$ll/24;

    $gama=sin($b)*$ll + sin($b)*cos($b)*cos($b)*
          (1+3*$eta2+2*$eta2*$eta2) *
          ($ll*$ll*$ll/3) + sin($b)*cos($b)*cos($b)*cos($b)*cos($b)*
          (2-$t*$t) *  $ll*$ll*$ll*$ll*$ll/15;

		$gaussblxy["x"]=$x;
		$gaussblxy["y"]=$y;
		$gaussblxy["m"]=$m;
		$gaussblxy["gama"]=$gama;
		
		return ($gaussblxy);				
}
	
function jtsks42dbdl($xjtsk,$yjtsk) {
  	$ro = 57.295779513082321;

     $y=$yjtsk/1000000;        $x=$xjtsk/1000000;
     $kk=   6.4581309976;
     $a= -25.2396636867;
     $b=  -6.31688387734;
     $c=  25.3931214924;
     $d=   6.4794973420;
     $e=   2.8729496693;
     $f=  -7.3246633461;
     $g=  -2.42395424509;
     $h=  -1.1948940070888;
     $k=  -0.1977771878;
     $db=$kk + $a*$x + $b*$y + $c*$x*$x + $d*$x*$y + $e*$y*$y +$f*$x*$x*$x
           + $g*$x*$x*$y + $h*$x*$y*$y  + $k*$y*$y*$y;
     $db=$db/3600/$ro;
     $kk=   2.763002544688;
     $a= -21.17728368056;
     $b=   9.75152384040;
     $c=  20.98226652614;
     $d=   0.929265490037;
     $e=  -1.52922105939;
     $f=  -5.861019136333;
     $g=  -2.860928322308;
     $h=   0.8723432775432;
     $k=   0.438453018241;
     $dl=$kk + $a*$x + $b*$y + $c*$x*$x + $d*$x*$y + $e*$y*$y +$f*$x*$x*$x
           + $g*$x*$x*$y + $h*$x*$y*$y  + $k*$y*$y*$y;
     $dl=$dl/3600/$ro;
	
	$jtsks42dbdl["db"] = $db;
	$jtsks42dbdl["dl"] = $dl;		
	return($jtsks42dbdl);
}
		
function ypas($y) {
  $pas = intval($y/1000000);
  if ($pas < 3) $pas = 3;
  return($pas); 
}	
  
function krovakxyfl ($xjtsk,$yjtsk) {
    $maler=6380703.6105;
    $ro = 57.295779513082321;

    $r=sqrt($xjtsk*$xjtsk+$yjtsk*$yjtsk);
    $epsilon=atan($yjtsk/$xjtsk);

    $q=tan(84.25/$ro)* mocni(1298039.0046/$r,1/0.9799247046);
    $s=2*atan($q)-(90/$ro);
    $d=$epsilon/sin(78.5/$ro);

    $a=(30+17/60+17.30311/3600)/$ro;
    $sinu=cos($a)*sin($s)-sin($a)*cos($s)*cos($d);
    $cosu=sqrt(1-$sinu*$sinu);
    $tanu=$sinu/$cosu;
    $u=atan($tanu);
    $v=(42+31/60+31.41725/3600)/$ro;
    $sinvkv=cos($s)*sin($d)/cos($u);
    $cosvkv=sqrt(1-$sinvkv*$sinvkv);
    $tanvkv=$sinvkv/$cosvkv;
    $vkv=atan($tanvkv);
    $v=$v-$vkv;

    $deltau=$u*$ro-(49+27/60+35.84625/3600);
    $duh=$deltau*0.36;
    $dfi=10014.16023*$duh-2.4130973*$duh*$duh;
    $dfi=$dfi+0.0128873*$duh*$duh*$duh+0.0025186*$duh*$duh*$duh*$duh;
    $dfi=$dfi-0.0000025*$duh*$duh*$duh*$duh*$duh;
    $fi=(49.5+$dfi/3600)/$ro;
    $lambdaf=$v/1.0005974983;

    $n=sin(78.5/$ro);
    $mjtsk=$n*$r/($maler*cos($s));

    $a=(30+17/60+17.30311/3600)/$ro;
    $sintheta=sin($a)*sin($d)/cos($u);
    $costheta=sqrt(1-$sintheta*$sintheta);
    $theta=atan($sintheta/$costheta);
    $c=$epsilon-$theta;
    $c=-$c;

		$krovakxyfl["fi"]=$fi;
		$krovakxyfl["lambdaf"]=$lambdaf;
		$krovakxyfl["mjtsk"]=$mjtsk;
		$krovakxyfl["c"]=$c;
		
		return($krovakxyfl); 
}
	
function lpas($l) {
  	$ro = 57.295779513082321;
    return (intval($l*$ro/6)+1);
}	
	
function xy42jtskall($x42,$y42) {
  	$ro = 57.295779513082321;
  	$grfek = 17.6666666667;

    $pas=ypas($y42);
    $gauss_xybl=gaussxybl($x42,$y42);
    $krovak_flxy=krovakflxy($gauss_xybl["b"],$gauss_xybl["l"]+$grfek/$ro);

    $jtsks42_dbdl=jtsks42dbdl($krovak_flxy["xjtsk"],$krovak_flxy["yjtsk"]);
    $fi=$gauss_xybl["b"]-$jtsks42_dbdl["db"];
    $lambdaf=$gauss_xybl["l"]-$jtsks42_dbdl["dl"]+$grfek/$ro;
    $krovak_flxy=krovakflxy($fi,$lambdaf);
    $lambdag=$lambdaf-$grfek/$ro;

		$xy42jtskall["b42"]=$gauss_xybl["b"];
		$xy42jtskall["l42"]=$gauss_xybl["l"];
		$xy42jtskall["pas"]=$pas;
		$xy42jtskall["gama42"]=$gauss_xybl["gama"];
		$xy42jtskall["m42"]=$gauss_xybl["m"];
		$xy42jtskall["xjtsk"]=$krovak_flxy["xjtsk"];
		$xy42jtskall["yjtsk"]=$krovak_flxy["yjtsk"];
		$xy42jtskall["mjtsk"]=$krovak_flxy["mjtsk"];
		$xy42jtskall["c"]=$krovak_flxy["c"];
		$xy42jtskall["fi"]=$fi;
		$xy42jtskall["lambdaf"]=$lambdaf;
		$xy42jtskall["lambdag"]=$lambdag;
		
		return($xy42jtskall);		
}

function gaussxybl($x,$y) {
	  $ro = 57.295779513082321;

    $yy=$y;
    $a=6378245; $c=6356863.019;
    $e2=0.673852541468/100; $ee=0.669342162297/100;
    $pas=ypas($y);
    $lnula=$pas*6-3;
    $b=$x/111134.861084;
    $br=$b/$ro;
    $y=$y-$pas*1000000-500000;
    $db=16036.480269     * sin(2*$br);
    $db=$db  - 16.828067  * sin(4*$br);
    $db=$db  + 0.021975   * sin(6*$br);
    $db=$db  - 0.000031   * sin(8*$br);
    $t=sin($br)/cos($br);
    $eta2=$e2*cos($br)*cos($br);
    $n=$a*$a/($c*sqrt($eta2+1));
    $b=$b+$db*$ro*(1+$eta2)/$n;
    $b=$b-(3*$ro*$t*$db*$db*$eta2) * (1+$eta2)/(2*$n*$n);
    $b=$b-($ro*$db*$db*$db*$eta2)  *
       (1-$t*$t+2*$eta2-6*$t*$t*$eta2)/(2*$n*$n*$n);
    $br=$b/$ro;
    $t=sin($br)/cos($br);
    $eta2=$e2 *cos($br )*cos($br);
    $n=$a*$a/($c*sqrt($eta2+1));

    $l=$lnula;
    $l1=($ro*$y)/($n*cos($br));
    $l=$l+$l1;
    $l2=-($ro*$y*$y*$y)*(1+2*$t*$t+$eta2)/(6*$n*$n*$n*cos($br));
    $l=$l+$l2;
    $l3=($ro*$y*$y*$y*$y*$y)*(5+28*$t*$t+
         24*$t*$t*$t*$t+6*$eta2+8*$t*$t*$eta2)/
        (120*$n*$n*$n*$n*$n*cos($br));
    $l=$l+$l3;

    $b=$b-($ro*$t*$y*$y)*(1+$eta2)/(2*$n*$n);
    $b=$b+($ro*$t*$y*$y*$y*$y)*
       (5+3*$t*$t+6*$eta2-6*$t*$t*$eta2-3*$eta2*$eta2-9*$t*$t*$eta2*$eta2)
        /(24*$n*$n*$n*$n);
    $y=$yy;
    $l=$l/$ro; $b=$b/$ro;

    $ll=$l-$lnula/$ro;
    $m=1+ cos($b)*cos($b)*(1+$eta2)*$ll*$ll/2+cos($b)*
          cos($b)*cos($b)*cos($b)*
          (5-4*$t*$t)*$ll*$ll*$ll*$ll/24;

    $gama=sin($b)*$ll +
          sin($b)*cos($b)*cos($b)*(1+3*$eta2+2*$eta2*$eta2) *
          ($ll*$ll*$ll/3) + sin($b)*cos($b)*cos($b)*cos($b)*cos($b)*
          (2-$t*$t) * $ll*$ll*$ll*$ll*$ll/15;

		$gaussxybl["pas"]=$pas;
		$gaussxybl["b"]=$b;
		$gaussxybl["l"]=$l;
		$gaussxybl["m"]=$m;
		$gaussxybl["gama"]=$gama;

		return($gaussxybl);
}
  
function krovakflxy($fi,$lambdaf) {

    $alfa =1.000597498372;
    $e =0.0816968303;
    $e2 =0.00667437223061;
    $rnula =1298039.0046;
    $k=1.003419164;
    $maler=6380703.6105;
    $ro = 57.295779513082321;

    $tanu=(1-$e*sin($fi))/(1+$e *sin($fi));
    $eexp=$alfa*$e/2;
    $tanu=mocni($tanu,$eexp);
    $tanu=$tanu *$k *mocni(tan($fi/2+45/$ro),$alfa);
    $tanu=atan($tanu)-45/$ro;
    $u=$tanu*2;
    $v=$lambdaf*$alfa;

    $ua=decrad(48+12/60+42.69689/3600);
    $vk=decrad(42+31/60+31.41725/3600);
    $uk=decrad(59+42/60+42.69689/3600);
    $sins=sin($uk)*sin($u) + cos($uk)*cos($u)*cos($vk-$v);
    $coss=sqrt(1-$sins*$sins);
    $s=atan($sins/$coss);
    $sind=cos($u)*sin($vk-$v)/(sqrt(1-$sins*$sins));
    $cosd=sqrt(1-$sind*$sind);
    $d=atan($sind/$cosd);

    $n=sin(78.5/$ro);
    $epsilon=$d*$n;
    $r=$rnula *mocni(tan(84.25/$ro),$n);
    $r=$r/mocni(tan(45/$ro+$s/2),$n);

    $xjtsk=$r*cos($epsilon);   $yjtsk=$r*sin($epsilon );

    $mjtsk=$n*$r/($maler*cos($s));

    $a=(30+17/60+17.30311/3600)/$ro;
    $sintheta=sin($a)*sin($d)/cos($u);
    $costheta=sqrt(1-$sintheta*$sintheta);
    $theta=atan($sintheta/$costheta);
    $c=$epsilon-$theta;
    $c=-$c;

		
    $krovakflxy["xjtsk"]=$xjtsk;
    $krovakflxy["yjtsk"]=$yjtsk;
    $krovakflxy["mjtsk"]=$mjtsk;
    $krovakflxy["c"]=$c;				
		
    return($krovakflxy);
}
	
function xyjtsk52all($xjtsk,$yjtsk) {
    $grfe = 17.6665931667;
    $ro   = 57.295779513082321;						 
       $krovak_xyfl=krovakxyfl($xjtsk,$yjtsk);
       $jtsks52_dbdl=jtsks52dbdl($xjtsk,$yjtsk);
       $b52=$krovak_xyfl["fi"]+$jtsks52_dbdl["db"];
       $l52=$krovak_xyfl["lambdaf"]-$grfe/$ro+$jtsks52_dbdl["dl"];
       $pas=lpas($l52);
       $gauss_blxy=gaussblxy($b52,$l52,$pas);
       $lambdag=$krovak_xyfl["lambdaf"]-$grfe/$ro;

 			 $xyjtsk52all["b52"]=$b52;
			 $xyjtsk52all["l52"]=$l52;
			 $xyjtsk52all["pas"]=$pas;
			 $xyjtsk52all["gama52"]=$gauss_blxy["gama"];
			 $xyjtsk52all["m52"]=$gauss_blxy["m"];
			 $xyjtsk52all["x52"]=$gauss_blxy["x"];
			 $xyjtsk52all["y52"]=$gauss_blxy["y"];
			 $xyjtsk52all["fi"]=$krovak_xyfl["fi"];
			 $xyjtsk52all["lambdaf"]=$krovak_xyfl["lambdaf"];
			 $xyjtsk52all["lambdag"]=$lambdag;
			 $xyjtsk52all["c"]=$krovak_xyfl["c"];
       $xyjtsk52all["mjtsk"]=$krovak_xyfl["mjtsk"];

       return($xyjtsk52all);
}

function jtsks52dbdl($xjtsk,$yjtsk) {

    $ro   = 57.295779513082321;	
    $y=$yjtsk/1000000;        $x=$xjtsk/1000000;
    $kk=-4.6646882192;
    $a= 3.7091175824;
    $b=-2.3982777630;
    $c= 0.33032733438;
    $d= 0.60870873196;
    $e= 1.0618597384;
    $f=-0.12981050105;
    $g= 0.011459645715;
    $h=-0.16229009822;
    $k=-0.011197738456;
    $db=$kk + $a*$x + $b*$y + $c*$x*$x + $d*$x*$y + $e*$y*$y +$f*$x*$x*$x
        + $g*$x*$x*$y + $h*$x*$y*$y  + $k*$y*$y*$y;
    $db=$db/3600/$ro;
    $kk=-6.799325277;
    $a= 4.276704132;
    $b= 10.540362944;
    $c=-0.74948487035;
    $d=-4.1908247218;
    $e= 0.71106826869;
    $f= 0.008062422824;
    $g= 0.61432628711;
    $h= 0.0053423421521;
    $k=-0.20059555161;
    $dl=$kk + $a*$x + $b*$y + $c*$x*$x + $d*$x*$y + $e*$y*$y +$f*$x*$x*$x
        + $g*$x*$x*$y + $h*$x*$y*$y  + $k*$y*$y*$y;
    $dl=$dl/3600/$ro;
		
		$jtsks52dbdl["db"]=$db;
		$jtsks52dbdl["dl"]=$dl;
		
		return($jtsks52dbdl);
 }

function xy52jtskall($x52,$y52) {

    $grfe = 17.6665931667;
    $ro   = 57.295779513082321;						 

       $pas=ypas($y52);
       $gauss_xybl=gaussxybl($x52,$y52);
       $krovak_flxy=krovakflxy($gauss_xybl["b"],$gauss_xybl["l"]+$grfe/$ro);
       $jtsks52_dbdl=jtsks52dbdl($krovak_flxy["xjtsk"],$krovak_flxy["yjtsk"]);
       $fi=$gauss_xybl["b"]-$jtsks52_dbdl["db"];
       $lambdaf=$gauss_xybl["l"]-$jtsks52_dbdl["dl"]+$grfe/$ro;
       $krovak_flxy=krovakflxy($fi,$lambdaf);
       $lambdag=$lambdaf-$grfe/$ro;

		$xy52jtskall["b52"]=$gauss_xybl["b"];
		$xy52jtskall["l52"]=$gauss_xybl["l"];
		$xy52jtskall["pas"]=$pas;
		$xy52jtskall["gama52"]=$gauss_xybl["gama"];
		$xy52jtskall["m52"]=$gauss_xybl["m"];
		$xy52jtskall["xjtsk"]=$krovak_flxy["xjtsk"];
		$xy52jtskall["yjtsk"]=$krovak_flxy["yjtsk"];
		$xy52jtskall["mjtsk"]=$krovak_flxy["mjtsk"];
		$xy52jtskall["c"]=$krovak_flxy["c"];
		$xy52jtskall["fi"]=$fi;
		$xy52jtskall["lambdaf"]=$lambdaf;
		$xy52jtskall["lambdag"]=$lambdag;
		
		return($xy52jtskall);		
}

function blkras42wgs84($b42,$l42) {

   $ro   = 57.295779513082321;	
   $fiwgs84=$b42-1.4/3600/$ro;
   $lambdawgs84=$l42-6.2/3600/$ro;

   if ($l42>(18/$ro)) {
     $fiwgs84=$b42-1.2/3600/$ro;
     $lambdawgs84=$l42-6.1/3600/$ro;
   }
	 
  $blkras42wgs84["fiwgs84"]=$fiwgs84;
  $blkras42wgs84["lambdawgs84"]=$lambdawgs84;
	
	return ($blkras42wgs84);
}
	
function blwgs84kras42($fiwgs84,$lambdawgs84) {
  
   $ro   = 57.295779513082321;	
   $b42=$fiwgs84+1.4/3600/$ro;
   $l42=$lambdawgs84+6.2/3600/$ro;

   if ($lambdawgs84>(18/$ro)) {
     $b42=$fiwgs84+1.2/3600/$ro;
     $l42=$lambdawgs84+6.1/3600/$ro; 
	 }
	 $blwgs84kras42["b42"]=$b42;
	 $blwgs84kras42["l42"]=$l42;
	 
	 return ($blwgs84kras42);
}  

function pas3gaussblxy($b,$l) {
    $ro   = 57.295779513082321;
    $a=6378245; $c=6356863.019;
    $e22=0.673852541468/100; $ee=0.669342162297/100;
    $e21=0.0066934216;
    $lnula=15;   $pas=3;
    $ll=($l-$lnula/$ro);
    $f2=$b*2;    $f4=$b*4;    $f6=$b*6;     $f8=$b*8;
    $bpruh=111134.861084*$b*$ro-16036.480269*sin($f2)+
           16.828067*sin($f4)-0.021975*sin($f6)
             +0.000031*sin($f8);
    $t=sin($b )/cos($b );
    $eta2=$e22*cos($b )*cos($b );
    $n=$a/sqrt(1-$e21*sin($b )*sin($b ));

    $x=$bpruh+$n*sin($b )*cos($b )*($ll*$ll/2);
    $x=$x+$n*sin($b )*cos($b )*cos($b )*cos($b )
      *(5-$t*$t+9*$eta2+4*$eta2*$eta2)*($ll*$ll*$ll*$ll/24);

    $y=$n*cos($b )*$ll;
    $y=$y+$n*cos($b )*cos($b )*cos($b )*(1-$t*$t+$eta2)*($ll*$ll*$ll/6);
    $y=$y+$n*cos($b )*cos($b )*cos($b )*cos($b )*cos($b )*
       (5-18*$t*$t+$t*$t*$t*$t+14*$eta2
       -58*$eta2*$t*$t)*($ll*$ll*$ll*$ll*$ll/120);
    $y=$y+500000+$pas*1000000;

    $m=1+ cos($b)*cos($b)*(1+$eta2)*$ll*$ll/2+
          cos($b)*cos($b)*cos($b)*cos($b)*
          (5-4*$t*$t)*$ll*$ll*$ll*$ll/24;

    $gama=sin($b)*$ll + sin($b)*cos($b)*cos($b)*
          (1+3*$eta2+2*$eta2*$eta2) * ($ll*$ll*$ll/3) +
          sin($b)*cos($b)*cos($b)*cos($b)*cos($b)*(2-$t*$t) *
          $ll*$ll*$ll*$ll*$ll/15;

    $pas3gaussblxy["x"]=$x;
		$pas3gaussblxy["y"]=$y;
		$pas3gaussblxy["m"]=$m;
		$pas3gaussblxy["gama"]=$gama;
		
		return ($pas3gaussblxy);
}	

function gaussyred($y,$pas) {
    return($y-$pas*1000000-500000);
}  

function xy42jtsk($x42,$y42) {
       $ro   = 57.295779513082321;
       $grfek = 17.6666666667;
       $pas=ypas($y42);
       $gauss_xybl=gaussxybl($x42,$y42,$pas);
       $krovak_flxy=krovakflxy($gauss_xybl["b42"],$gauss_xybl["l42"]+$grfe/$ro);
       $jtsks42_dbdl=jtsks42dbdl($krovak_flxy["xjtsk"],$krovak_flxy["yjtsk"]);
       $fi=$gauss_xybl["b42"]-$jtsks42_dbdl["db42"];
       $lambda=$gauss_xybl["l42"]-$jtsks42_dbdl["dl42"]+$grfek/$ro;
       $krovak_flxy=krovakflxy($fi,$lambda);
			 
			 $xy42jtsk["xjtsk"]=$krovak_flxy["xjtsk"];
			 $xy42jtsk["yjtsk"]=$krovak_flxy["yjtsk"];

	 return ($xy42jtsk);
}

function utmcentral($zone) {
      return(degtorad(-183.0 + ($zone * 6.0)));
}

function footpoint($y) {
$sm_a = 6378137.0;
$sm_b = 6356752.314;
        
	$n = ($sm_a - $sm_b) / ($sm_a + $sm_b);
        $alpha_ = (($sm_a + $sm_b) / 2.0)
            * (1 + (pow($n, 2.0) / 4) + (pow($n, 4.0) / 64));
        $y_ = $y / $alpha_;
        $beta_ = (3.0 * $n / 2.0) + (-27.0 * pow($n, 3.0) / 32.0)
            + (269.0 * pow($n, 5.0) / 512.0);
        $gamma_ = (21.0 * pow($n, 2.0) / 16.0)
            + (-55.0 * pow($n, 4.0) / 32.0);
        $delta_ = (151.0 * pow($n, 3.0) / 96.0)
            + (-417.0 * pow($n, 5.0) / 128.0);
        $epsilon_ = (1097.0 * pow($n, 4.0) / 512.0);
        $result = $y_ + ($beta_ * sin(2.0 * $y_))
            + ($gamma_ * sin(4.0 * $y_))
            + ($delta_ * sin(6.0 * $y_))
            + ($epsilon_ * sin (8.0 * $y_));
        
        return ($result);
}
   
function mapxy2fl($x, $y, $lambda0) {
$sm_a = 6378137.0;
$sm_b = 6356752.314;

        $phif = footpoint($y);
        $ep2 = (pow($sm_a, 2.0) - pow($sm_b, 2.0))
              / pow($sm_b, 2.0);
        $cf = cos ($phif);
        $nuf2 = $ep2 * pow($cf, 2.0);
        $nf = pow($sm_a, 2.0) / ($sm_b * sqrt(1 + $nuf2));
        $nfpow = $nf;
        $tf = tan($phif);
        $tf2 = $tf * $tf;
        $tf4 = $tf2 * $tf2;

        $x1frac = 1.0 / ($nfpow * $cf);
        $nfpow *= $nf;   /* now equals nf**2) */
        $x2frac = $tf / (2.0 * $nfpow);
        $nfpow *= $nf;   /* now equals nf**3) */
        $x3frac = 1.0 / (6.0 * $nfpow * $cf);
        $nfpow *= $nf;   /* now equals nf**4) */
        $x4frac = $tf / (24.0 * $nfpow);
        $nfpow *= $nf;   /* now equals nf**5) */
        $x5frac = 1.0 / (120.0 * $nfpow * $cf);
        $nfpow *= $nf;   /* now equals nf**6) */
        $x6frac = $tf / (720.0 * $nfpow);
        $nfpow *= $nf;   /* now equals nf**7) */
        $x7frac = 1.0 / (5040.0 * $nfpow * $cf);
        $nfpow *= $nf;   /* now equals nf**8) */
        $x8frac = $tf / (40320.0 * $nfpow);

        $x2poly = -1.0 - $nuf2;
        $x3poly = -1.0 - 2 * $tf2 - $nuf2;
        $x4poly = 5.0 + 3.0 * $tf2 + 6.0 * $nuf2 - 6.0 * $tf2 * $nuf2
        	- 3.0 * ($nuf2 *$nuf2) - 9.0 * $tf2 * ($nuf2 * $nuf2);
        $x5poly = 5.0 + 28.0 * $tf2 + 24.0 * $tf4 + 6.0 * $nuf2 + 8.0 * $tf2 * $nuf2;
        $x6poly = -61.0 - 90.0 * $tf2 - 45.0 * $tf4 - 107.0 * $nuf2
        	+ 162.0 * $tf2 * $nuf2;
        $x7poly = -61.0 - 662.0 * $tf2 - 1320.0 * $tf4 - 720.0 * ($tf4 * $tf2);
        $x8poly = 1385.0 + 3633.0 * $tf2 + 4095.0 * $tf4 + 1575 * ($tf4 * $tf2);

        $philambda["f"] = $phif + $x2frac * $x2poly * ($x * $x)
        	+ $x4frac * $x4poly * pow($x, 4.0)
        	+ $x6frac * $x6poly * pow($x, 6.0)
        	+ $x8frac * $x8poly * pow($x, 8.0);
        	
        $philambda["l"] = $lambda0 + $x1frac * $x
        	+ $x3frac * $x3poly * pow($x, 3.0)
        	+ $x5frac * $x5poly * pow($x, 5.0)
        	+ $x7frac * $x7poly * pow($x, 7.0);
				
		return($philambda);			
}
    
function utm2fl($x, $y, $zone, $southhemi) {
$utmscalefactor = 0.9996;
				
        $x -= 500000.0;
        $x /= $utmscalefactor;
        	
        if ($southhemi)
        $y -= 10000000.0;
        		
        $y /= $utmscalefactor;
        
        $cmeridian = utmcentral($zone);
        $fl = mapxy2fl($x, $y, $cmeridian);
				
				return($fl);
        	
}
		
function togeo($x,$y) {

$southhemi = false;
$zone=33;
        
				$togeo = utm2fl($x, $y, $zone, $southhemi);
				
				$togeo["f"] = radtodeg($togeo["f"]);
				$togeo["l"] = radtodeg($togeo["l"]);		

  return ($togeo);
}	
function toutm($f,$l) {

  $tm2ll=false; $ok=true;
  $deg2rad=pi/180.0;

    $f0=0.9996;
    $a1=6378137.0*$f0;
    $b1=6356752.3142*$f0;
    $k0=0;
    $n0=0;
    $e0=500000;
    

  $n1=($a1-$b1)/($a1+$b1); 
  $n2=$n1*$n1; $n3=$n2*$n1;
  $e2=(($a1*$a1)-($b1*$b1))/($a1*$a1); 

    $deg=$f["stupne"]; $min=$f["minuty"]; $sec=$f["vteriny"];
    if ($deg=='') $deg=0; if ($min=='') $min=0; if ($sec=='') $sec=0;

    $lat=1.0*abs($deg)+abs($min)/60.0+abs($sec)/3600.0;
		
    if ($lat>90) {echo "invalid latitude"; $ok=false; }

    $deg=$l["stupne"]; $min=$l["minuty"];$sec=$l["vteriny"];
    if ($deg=='') $deg=0; if ($min=='') $min=0; if ($sec=='') $sec=0;

    $long=1.0*abs($deg)+abs($min)/60.0+abs($sec)/3600.0;
    if ($long>180) {echo "invalid longitude"; $ok=false; }

    $k=deg2rad($lat); $l=deg2rad($long);
    $sink=sin($k); $cosk=cos($k); $tank=$sink/$cosk; $tank2=$tank*$tank;
    $cosk2=$cosk*$cosk; $cosk3=$cosk2*$cosk;
    $k3=$k-$k0; $k4=$k+$k0;

    $merid=15;
    $l0=deg2rad($merid);

    
    $j3=$k3*(1+$n1+1.25*($n2+$n3));
    $j4=sin($k3)*cos($k4)*(3*($n1+$n2+0.875*$n3));
    $j5=sin(2*$k3)*cos(2*$k4)*(1.875*($n2+$n3));
    $j6=sin(3*$k3)*cos(3*$k4)*35/24*$n3;
    $m=($j3-$j4+$j5-$j6)*$b1;

    
    $temp=1-$e2*$sink*$sink;
    $v=$a1/sqrt($temp);
    $r=$v*(1-$e2)/$temp;
    $h2=$v/$r-1.0;

    $p=$l-$l0; $p2=$p*$p; $p4=$p2*$p2;
    $j3=$m+$n0;
    $j4=$v/2*$sink*$cosk;
    $j5=$v/24*$sink*($cosk3)*(5-($tank2)+9*$h2);
    $j6=$v/720*$sink*$cosk3*$cosk2*(61-58*($tank2)+$tank2*$tank2);
    $north=$j3+$p2*$j4+$p4*$j5+$p4*$p2*$j6;
		
		
    $j7=$v*$cosk;
    $j8=$v/6*$cosk3*($v/$r-$tank2);
    $j9=$v/120*$cosk3*$cosk2;
    $j9=$j9*(5-18*$tank2+$tank2*$tank2+14*$h2-58*$tank2*$h2);
    $east=$e0+$p*$j7+$p2*$p*$j8+$p4*$p*$j9;
    $ieast=round($east); $inorth=round($north); // should strictly be trunc

    $x=$ieast;
    $y=$inorth;
		
		if ($ok) {
			 $xy["x"]=$x;
			 $xy["y"]=$y;
			 }
			 return($xy);
			 
}

function s42utm($x42,$y42) {

  $a=0.99959262999;
  $b =0.00000008995;
  $c =-2998698.271;
  $d=0.00000010000063;
  $e=0.9995923;
  $f =-97.777;

   $xutm = ($a*$x42) + ($b*$y42) + $c;
   $yutm = ($d*$x42) + ($e*$y42) + $f;

   $s42utm["x"]=$xutm;
   $s42utm["y"]=$yutm;

   return($s42utm);
}	
function utms42($ux,$uy) {
  $a=0.99959262999;
  $b=0.00000008995;
  $c=-2998698.271;
  $e=0.9995923;
  $d=0.00000010000063;
  $f=-97.777;

  $y=($d*$ux - $uy*$a -$d*$c +$f)/ ($d*$b - $e*$a);
  $x=($ux - $b*$y -$c)/$a;

  $utms42["x"]=$x;
  $utms42["y"]=$y;

  return($utms42);
}
?>
