<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: lltoutm.inc,v 1.1.1.1 2001/09/26 14:36:36 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

function utmletterdesignator($lat)
{
	if((84 >= $lat) && ($lat >= 72)) $letterdesignator = 'x';
	else if((72 > $lat) && ($lat >= 64)) $letterdesignator = 'w';
	else if((64 > $lat) && ($lat >= 56)) $letterdesignator = 'v';
	else if((56 > $lat) && ($lat >= 48)) $letterdesignator = 'u';
	else if((48 > $lat) && ($lat >= 40)) $letterdesignator = 't';
	else if((40 > $lat) && ($lat >= 32)) $letterdesignator = 's';
	else if((32 > $lat) && ($lat >= 24)) $letterdesignator = 'r';
	else if((24 > $lat) && ($lat >= 16)) $letterdesignator = 'q';
	else if((16 > $lat) && ($lat >= 8)) $letterdesignator = 'p';
	else if(( 8 > $lat) && ($lat >= 0)) $letterdesignator = 'n';
	else if(( 0 > $lat) && ($lat >= -8)) $letterdesignator = 'm';
	else if((-8> $lat) && ($lat >= -16)) $letterdesignator = 'l';
	else if((-16 > $lat) && ($lat >= -24)) $letterdesignator = 'k';
	else if((-24 > $lat) && ($lat >= -32)) $letterdesignator = 'j';
	else if((-32 > $lat) && ($lat >= -40)) $letterdesignator = 'h';
	else if((-40 > $lat) && ($lat >= -48)) $letterdesignator = 'g';
	else if((-48 > $lat) && ($lat >= -56)) $letterdesignator = 'f';
	else if((-56 > $lat) && ($lat >= -64)) $letterdesignator = 'e';
	else if((-64 > $lat) && ($lat >= -72)) $letterdesignator = 'd';
	else if((-72 > $lat) && ($lat >= -80)) $letterdesignator = 'c';
	else $letterdesignator = 'z'; //this is here as an error flag to show that the latitude is outside the utm limits

	return ($letterdesignator);
}

function fltoutm($lat,$long,$params=false) {
//const
$pi = 3.1415926535897932384626433832795;
$fourthpi = $pi / 4;
$deg2rad = $pi / 180.0;
$rad2deg = 180.0 / $pi;

  if (!$params) $params = array();

	$a = 6378137;
	$eccsquared = 0.00669438;
  $k0=$params["k0"]?$params["k0"]:0.9996;

	$longtemp = ($long+180)-intval(($long+180)/360)*360-180; // -180.00 .. 179.9;

	$latrad = $lat*$deg2rad;

	$longrad = $longtemp*$deg2rad;

  $zonenumber = $params["zone"];
  if (!$zonenumber) {
  	$zonenumber = intval(($longtemp + 180)/6) + 1;
  
  	if(($lat >= 56.0) && ($lat < 64.0) && ($longtemp >= 3.0) && ($longtemp < 12.0))
  		$zonenumber = 32;
  
  	if(($lat >= 72.0) && ($lat < 84.0)) 
  	{
  	  if(      ($longtemp >= 0.0)  && ($longtemp <  9.0) ) $zonenumber = 31;
  	  else if( ($longtemp >= 9.0)  && ($longtemp < 21.0) ) $zonenumber = 33;
  	  else if( ($longtemp >= 21.0) && ($longtemp < 33.0) ) $zonenumber = 35;
  	  else if( ($longtemp >= 33.0) && ($longtemp < 42.0) ) $zonenumber = 37;
  	 }
  }
  $longorigin = $params["longorigin"];
  if (!$longorigin) {
  	$longorigin = ($zonenumber - 1)*6 - 180 + 3;  //+3 puts origin in middle of zone
  }

	$longoriginrad = $longorigin * $deg2rad;

	//sprintf($utmzone, "%d%c", $zonenumber, $utmletterdesignator($lat));

	$eccprimesquared = ($eccsquared)/(1-$eccsquared);

	$n = $a/sqrt(1-$eccsquared*sin($latrad)*sin($latrad));
	$t = tan($latrad)*tan($latrad);
	$c = $eccprimesquared*cos($latrad)*cos($latrad);
	$A = cos($latrad)*($longrad-$longoriginrad);

	$m = $a*((1	- $eccsquared/4		- 3*$eccsquared*$eccsquared/64	- 5*$eccsquared*$eccsquared*$eccsquared/256)*$latrad 
				- (3*$eccsquared/8	+ 3*$eccsquared*$eccsquared/32	+ 45*$eccsquared*$eccsquared*$eccsquared/1024)*sin(2*$latrad)
									+ (15*$eccsquared*$eccsquared/256 + 45*$eccsquared*$eccsquared*$eccsquared/1024)*sin(4*$latrad) 
									- (35*$eccsquared*$eccsquared*$eccsquared/3072)*sin(6*$latrad));
	
	$utmeasting =($k0*$n*($A+(1-$t+$c)*$A*$A*$A/6
					+ (5-18*$t+$t*$t+72*$c-58*$eccprimesquared)*$A*$A*$A*$A*$A/120)
					+ 500000.0);
  

	$utmnorthing =($k0*($m+$n*tan($latrad)*($A*$A/2+(5-$t+9*$c+4*$c*$c)*$A*$A*$A*$A/24
				 + (61-58*$t+$t*$t+600*$c-330*$eccprimesquared)*$A*$A*$A*$A*$A*$A/720)));				 
		 
	if($lat < 0)
	$utmnorthing += 10000000.0; //10000000 meter offset for southern hemisphere

	$utmxy["x"]=$utmeasting+$params["xshift"];
	$utmxy["y"]=$utmnorthing+$params["yshift"];
  
	return($utmxy);
}




function utmtofl($utmeasting,$utmnorthing,$params) {
//const
$pi = 3.1415926535897932384626433832795;
$fourthpi = $pi / 4;
$deg2rad = $pi / 180;
$rad2deg = 180.0 / $pi;

  $k0=$params["k0"]?$params["k0"]:0.9996;
	$a = 6378137;
	$eccsquared = 0.00669438;
	$e1 = (1-sqrt(1-$eccsquared))/(1+sqrt(1-$eccsquared));
	$x = $utmeasting - 500000.0; //remove 500,000 meter offset for longitude
	$y = $utmnorthing;

  $northernhemisphere = 1;//point is in northern hemisphere

  $zonenumber = $params["zone"]?$params["zone"]:33;
  
  $longorigin = $params["longorigin"];
  if (!$longorigin) {
  	$longorigin = ($zonenumber - 1)*6 - 180 + 3;  //+3 puts origin in middle of zone
  }

	$eccprimesquared = ($eccsquared)/(1-$eccsquared);

	$m = $y / $k0;
	
	$mu = $m/($a*(1-$eccsquared/4-3*$eccsquared*$eccsquared/64-5*$eccsquared*$eccsquared*$eccsquared/256));

	$phi1rad = $mu	+ (3*$e1/2-27*$e1*$e1*$e1/32)*sin(2*$mu) 
				+ (21*$e1*$e1/16-55*$e1*$e1*$e1*$e1/32)*sin(4*$mu)
				+(151*$e1*$e1*$e1/96)*sin(6*$mu);
		
//	$phi1 = $phi1rad;	
	$phi1 = $phi1rad*$rad2deg;

	$n1 = $a/sqrt(1-$eccsquared*sin($phi1rad)*sin($phi1rad));
	$t1 = tan($phi1rad)*tan($phi1rad);
	$c1 = $eccprimesquared*cos($phi1rad)*cos($phi1rad);
	$r1 = $a*(1-$eccsquared)/pow(1-$eccsquared*sin($phi1rad)*sin($phi1rad), 1.5);
	$d = $x/($n1*$k0);

	$lat = $phi1rad - ($n1*tan($phi1rad)/$r1)*($d*$d/2-(5+3*$t1+10*$c1-4*$c1*$c1-9*$eccprimesquared)*$d*$d*$d*$d/24
					+(61+90*$t1+298*$c1+45*$t1*$t1-252*$eccprimesquared-3*$c1*$c1)*$d*$d*$d*$d*$d*$d/720);
				
	$lat = $lat * $rad2deg;

	$long = ($d-(1+2*$t1+$c1)*$d*$d*$d/6+(5-2*$c1+28*$t1-3*$c1*$c1+8*$eccprimesquared+24*$t1*$t1)
					*$d*$d*$d*$d*$d/120)/cos($phi1rad);


//	$long = ($longorigin + $long) * $deg2rad ;
	$long = $longorigin + $long * $rad2deg;

	$utmfl["x"]=$long+$params["xshift"];
	$utmfl["y"]=$lat+$params["yshift"];

	return($utmfl);
}
?>
