<?php
/*=======================================================================
// File: 				JPGRAPH_CANVAS.PHP
// Description: 		Canvas drawing extension for JpGraph
// Created: 			2001-01-08
//	Last edit:			14/09/01 13:35
// Author:				Johan Persson (johanp@aditus.nu)
// Ver:					$Id: jpgraph_canvas.php,v 1.2 2001/11/05 15:08:56 tokr Exp $
//
// License:				This code is released under GPL 2.0
//
//========================================================================
*/

//===================================================
// CLASS CanvasGraph
// Description: Creates a simple canvas graph which
// might be used together with the basic Image drawing
// primitives. Useful to auickoly produce some arbitrary
// graphic which benefits from all the functionality in the
// graph liek caching for example. 
//===================================================
class CanvasGraph extends Graph {
//---------------
// CONSTRUCTOR
	function CanvasGraph($aWidth=300,$aHeight=200,$aCachedName="",$timeout=0,$inline=1) {
		$this->Graph($aWidth,$aHeight,$aCachedName,$timeout,$inline);
	}

//---------------
// PUBLIC METHODS	

	// Method description
	function Stroke() {
		if( $this->texts != null )
			foreach( $this->texts as $t) {
				$t->x *= $this->img->width;
				$t->y *= $this->img->height;
				$t->Stroke($this->img);
			}
				
		// Finally stream the generated picture					
		$this->cache->PutAndStream($this->img,$this->cache_name,$this->inline);	
	}

} // Class
/* EOF */
?>