<?php
//=========================================================================
// Name:			adjimg.php
// Written by: Johan Persson (johanp@aditus.nu)
// Last edit:	14/09/01 13:32	
// Ver: 			$Id: adjimg.php,v 1.1 2001/11/05 15:08:56 tokr Exp $
// Description:
// Utility to take an image and adjust it's brightness and contrast and 
// display it. The original file is untouched.
//
// Usage: adjimg.php?file=name&b=value&c=value&s=scale
//=========================================================================

function LoadImage($filename,$format="png") {
	$f = "imagecreatefrom".$format;
	$img = @$f($filename);
	if( !$img ) {
		die("Error: Can't read image file: $filename");   
	}
	return $img;
}

function AdjBrightContrast($img,$bright,$contr) {
	$nbr = imagecolorstotal ($img);
	for( $i=0; $i<$nbr; ++$i ) {
		$colarr = imagecolorsforindex ($img,$i);
		$r = AdjRGBBrightContrast($colarr["red"],$bright,$contr);
		$g = AdjRGBBrightContrast($colarr["green"],$bright,$contr);
		$b = AdjRGBBrightContrast($colarr["blue"],$bright,$contr);		
		imagecolorset ($img, $i, $r, $g, $b);
	}
}

function AdjRGBBrightContrast($rgb,$bright,$contr) {
	// First handle contrast, i.e change the dynamic range
	// around grey
	if( $contr <= 0 ) {
		// Decrease contrast
		$adj = abs($rgb-128) * (-$contr);
		if( $rgb < 128 ) 
			$rgb += $adj;
		else 
			$rgb -= $adj;
	}
	else { // $contr > 0
		// Increase contrast
		if( $rgb < 128 )
			$rgb = $rgb - ($rgb * $contr);
		else
			$rgb = $rgb + ((255-$rgb) * $contr);
	}
	
	// Add (or remove) various amount of white
	$rgb += $bright*255;	
	$rgb=min($rgb,255);
	$rgb=max($rgb,0);
	return $rgb;	
}
	
if( empty($file) )
	die("<b>Usage:</b><br>r.php?file=name&b=value&c=value&s=scale<p>
	file= Filename, must end with the image format, i.e. .png, .jpg, .gif<br>
	b	= Brightness value [-1, 1]<br>
	c	= Contrast value [-1, 1]<br>
	s	= Scale<br>");

if(strstr($file,"png")) 
	$bkg = LoadImage($file);
elseif( strstr($file,"jpg")) 
	$bkg = LoadImage($file,"jpeg");
elseif( strstr($file,"gif")) 
	$bkg = LoadImage($file,"gif");		
	
if( empty($b) ) $b=0;
if( empty($c) ) $c=0;
if( empty($s) ) $s=1;

// Adjust contrast and brightness of background color
AdjBrightContrast($bkg,$b,$c);

$bw = ImageSX($bkg);
$bh = ImageSY($bkg);

// Scale image
$w=$bw*$s;
$h=$bh*$s;

$img = imagecreate($w,$h);
imagecopyresized($img,$bkg,0,0,0,0,$w,$h,$bw,$bh);
$background_color = ImageColorAllocate ($img, 255, 255, 255);

if(strstr($file,"png")) {
	header ("Content-type: image/png");
	imagepng($img);
}
elseif( strstr($file,"jpg")) {
	header ("Content-type: image/jpeg");
	imagejpeg($img);	
}
elseif( strstr($file,"gif")) {
	header ("Content-type: image/gif");
	imagegif($img);	
}
else
	die("Unknown graphic format in file $file");
?>