<?php
require_once ('main.inc');

class Export_Obj_XML extends Export_Obj_Main
{ 
  var $count_lines = 0;
  var $record = array();
  var $output_charset = 'windows-1250';

  function ExportStart() {

    Header("Pragma: no-cache");
    Header("Cache-Control: no-cache");
    Header("Content-Type: text/xml");

    $this->FlushLine('<?xml version="1.0" encoding="'.$this->output_charset.'" ?>');
    $this->FlushLine('<data>');

    $this->CreateStructHeader();

    $this->FlushLine('<records>');
    
    return true; 
  } 

  
  function ExportEnd() {
    
    $this->FlushLine('</records>');
    $this->FlushLine('<count sum="'.$this->count_lines.'" />');
    $this->FlushLine('</data>');
  
    return true; 
  } 

  
  function RecordStart() {

    $this->count_lines++;

    $this->record = array();
    
    $this->FlushLine('<row num="'.$this->count_lines.'">');

    return true; 
  } 

  
  function RecordEnd() {
     
    foreach($this->record as $l => $v){
      $this->FlushLine('<column name="'.$l.'">'.$v.'</column>',true);
    }
      
    $this->FlushLine('</row>');
  
    return true; 
  } 

  
  function NextField($label,$value) {

    $this->record[$label] = $value; 

    return true; 
  }
  
  
  function CreateStructHeader(){

    $this->FlushLine('<header>');    

    foreach($this->config['schema'] as $f){
      $this->FlushLine('<column name="'.$f['label'].'" />',true);
    }

    $this->FlushLine('</header>');    
  } 

}

?>