<?php
require_once ('main.inc');

class Export_Obj_XHTML extends Export_Obj_Main
{
  var $count_lines = 0;
  var $record = array();
  var $output_charset = 'windows-1250';

  function ExportStart($header='') {

    $this->FlushLine('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">');
    $this->FlushLine('<html xmlns="http://www.w3.org/1999/xhtml">');
    $this->FlushLine('<head>');
    $this->FlushLine('<title>'.$this->config['title'].'</title>',true);
	  $this->FlushLine('<meta http-equiv="Content-Type" content="text/html; charset='.$this->output_charset.'" />');
    $this->FlushLine('</head>');
    $this->FlushLine('<body>');
    $this->FlushLine('<table>');
    
    if($header) $this->FlushLine($header);
    
    $this->CreateStructHeader();
  
    return true;
  } 


  function ExportEnd($footer='') {

    $this->FlushLine('</table>');
    $this->FlushLine('</body>');
    $this->FlushLine('</html>');

    if($footer) $this->FlushLine($footer);

    return true;
  } 


  function RecordStart() {

    $this->count_lines++;

    $this->record = array();
    
    $this->FlushLine('<tr>');

    return true;
  } 


  function RecordEnd() {

    foreach($this->record as $l => $v){
      $this->FlushLine('<td>'.$this->CharsetEncode(nl2br($v)).'</td>',true);
    }
      
    $this->FlushLine('</tr>');

    return true;
  } 


  function NextField($label,$value) {

    $this->record[$label] = $value; 

    return true;
  }


  function CreateStructHeader(){

    $this->FlushLine('<tr>');    

    foreach($this->config['schema'] as $f){
      $this->FlushLine('<th>'.$f['label'].'</th>',true);
    }

    $this->FlushLine('</tr>');    
  } 
  
}
?>
