<?php
require_once ('main.inc');

class Export_Obj_Tabbed extends Export_Obj_Main
{ 
  var $count_lines = 0;
  var $record = array();
  var $header = array();
  var $seperator_fields = "\t";
  var $seperator_fields_alt = ',';
  var $output_charset = 'windows-1250';

  
  function ExportStart() {
    Header("Content-Type: application/vnd.ms-excel; name='excel'");
    Header("Content-Disposition: attachment;filename=export.xls");
    return true; 
  } 

  
  function ExportEnd() {
    
    $this->FlushLine('COUNT:'.$this->seperator_fields.$this->count_lines);
  
    return true; 
  } 

  
  function RecordStart() {

    $this->count_lines++;
    
    //vytvoreni seznamu nazvu polozek (je to tady, abych to nemusel pro CSV, ktere je potomek) definovat v ExportStart() znovu
    if($this->count_lines==1){
      foreach($this->config['schema'] as $f) $header[] = $f['label'];
      $this->FlushLine(implode($this->seperator_fields, $header),true);
    }    

    $this->record = array();

    return true; 
  } 
  

  function RecordEnd() {
    
    $this->FlushLine($this->NoEnter(implode($this->seperator_fields, $this->record)),true);
  
    return true; 
  } 
  

  function NextField($label,$value) {

    $this->record[$label] = $this->NoSeparator($value); 

    return true; 
  }
  

  function NoSeparator($str){
    return str_replace($this->seperator_fields, $this->seperator_fields_alt, $str);
  }

}

?>