<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_pgsql.inc,v 1.20 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class DB_Sql_PgSQL {
  var $Host     = "";
  var $Database = "";
  var $User     = "";
  var $Password = "";
  var $Port = false;
  var $Encoding = false;

  var $Link_ID  = 0;
  var $Query_ID = 0;
  var $Record   = array();
  var $Row      = 0;
  var $Date_Format = "Y-m-d";
  var $Time_Format = "H:i:s";
  var $TrimStrings = false;

  var $EnableNestLoop = true;

  var $ShowError = true;
  var $Errno    = 0;
  var $Error    = "";
  var $Error_Die = true;
  
  var $Num_Rows = 0;
  var $SQL_Paging = 1;
  var $Last_SQL_Paging = 0;
  var $Query_String = "";
  var $Fce_Like = "ILIKE";
//  var $Fce_Upper = "UPPER";  // tohu - povolit pouze v pripade zruseni Fce_Like

  var $Auto_Free = 1; # Set this to 1 for automatic pg_freeresult on 
                      # last record.

  function ifadd($add, $me) {
	  if("" != $add) return " ".$me.$add;
  }
  
  function connect() {
	  if ( 0 == $this->Link_ID ) {
		  $cstr = "dbname=".$this->Database.
		  $this->ifadd($this->Host, "host=").
		  $this->ifadd($this->Port, "port=").
		  $this->ifadd($this->User, "user=").
		  $this->ifadd($this->Password, "password=");
		  $this->Link_ID=pg_pconnect($cstr);
		  if (!$this->Link_ID) {
			  $this->halt("Link-ID == false, pconnect failed");
		  }
      if ($this->Encoding) pg_set_client_encoding ($this->Link_ID,$this->Encoding);
      //EnableNestLoop - default is switched off on PostgreSQL for PostGIS optimizer - TOKR
      if ($this->EnableNestLoop) pg_Exec($this->Link_ID, 'SET enable_NESTLOOP = true;');  
	  }
  }

  function query_page($Query_String, $offset, $count) {
    if (!ERegi("DISTINCT", $Query_String)):
      $Query_String_Page = $Query_String." LIMIT $count OFFSET $offset";
  //    echo($Query_String_Page);
      $this->query($Query_String_Page);
      $this->Query_String = $Query_String;
      $this->Last_SQL_Paging = 1;
    else:
      $this->query($Query_String);
      $this->Last_SQL_Paging = 0;
    endif;
    return $this->Query_ID;
  }
  

  function query($Query_String) {
    
    $Query_String = str_replace("\\", "\\\\", $Query_String);

    $this->Query_String = $Query_String;
    $this->connect();

    //if ($GLOBALS["REMOTE_ADDR"]=="192.168.1.30") printf("<br>Debug: query = %s<br>\n", $Query_String);
    //flush();

    $this->Num_Rows = -1;
    $this->Query_ID = @pg_Exec($this->Link_ID, $Query_String);
    $this->Row   = 0;

    $this->Error = pg_ErrorMessage($this->Link_ID);
    $this->Errno = ($this->Error == "")?0:1;
    if (!$this->Query_ID) {
      $this->halt("Invalid SQL: ".$Query_String);
    }

    $this->Last_SQL_Paging = 0;
    return $this->Query_ID;
  }
  
  function Tran_Begin(){
     $this->query("BEGIN");
  }

  function Tran_Commit(){
     $this->query("COMMIT");
  }
  
  function Tran_Rollback(){
     $this->query("ROLLBACK");
  }

  function Tran_Lock_Table($tablename){
     $this->query("LOCK TABLE $tablename IN ACCESS EXCLUSIVE MODE");
  }

  function next_record() {
    $this->Record = @pg_fetch_array($this->Query_ID, $this->Row++);
    
    $this->Error = pg_ErrorMessage($this->Link_ID);
    $this->Errno = ($this->Error == "")?0:1;

    $stat = is_array($this->Record);
    if (!$stat && $this->Auto_Free) {
      pg_freeresult($this->Query_ID);
      $this->Query_ID = 0;
    }
    if ($stat):
      $arr = array();
      reset($this->Record);
      while (list($key, $val) = each($this->Record))
        if ($this->TrimStrings) 
          $arr[StrToUpper($key)] = Is_String($val)?Trim($val):$val;
        else 
          $arr[StrToUpper($key)] = $val;
      $this->Record = $arr;  
      return $stat;
    endif;
    }

  function seek($pos) {
    $this->Row = $pos;
  }

  function lock($table, $mode = "write") {
    if ($mode == "write") {
      $result = pg_Exec($this->Link_ID, "lock table $table");
    } else {
      $result = 1;
    }
    return $result;
  }
  
  function unlock() {
    return pg_Exec($this->Link_ID, "commit");
  }

  function metadata($table) {
    $count = 0;
    $id    = 0;
    $res   = array();
    
    $this->connect();
    $sql = "SELECT a.attname as name, t.typname as type, (CASE WHEN a.attlen > 0 THEN a.attlen ELSE a.atttypmod-4 END) as len, a.attnotnull as notnull FROM pg_attribute a, pg_type t, pg_class c WHERE c.relname = '".StrToLower($table)."' AND a.atttypid = t.oid AND a.attrelid = c.oid AND a.attnum > 0 ORDER BY a.attnum";
//    echo $sql; 
    $id = pg_exec($this->Link_ID, $sql);
    $i = 0;
    $count = pg_numrows($id);
    for ($i=0; $i<$count; $i++) {
      $arr = pg_fetch_array($id, $i);  
      $res[$i]["table"] = StrToUpper($table);
      $res[$i]["name"]  = StrToUpper($arr["name"]);
      $res[$i]["type"]  = $arr["type"];
      if (StrCmp($res[$i]["type"],"numeric") == 0)  
		  	$res[$i]["len"]   = ($arr["len"]+4 >> 16) & 0xffff;
      elseif(stristr($res[$i]["type"],'int'))
		  	$res[$i]["len"]   = strlen(pow(2,($arr["len"]*8))/2)-1;
      elseif(stristr($res[$i]["type"],'float'))
		  	$res[$i]["len"]   = strlen(pow(2,($arr["len"]*8))/2)-4;
      else
        $res[$i]["len"]   = $arr["len"]<0?80:$arr["len"];
        
      $res[$i]["null"]  = (StrCmp($arr["notnull"],"t") == 0)?false:true;
      $res[$i]["flags"] = 0;
//      $res[$res[$i]["name"]] = $res[$i];
    }
    
//    print_r($res);
    pg_FreeResult($id);
    return $res;
  }

  function affected_rows() {
    return pg_cmdtuples($this->Query_ID);
  }

  function num_rows() {
    if ($this->Num_Rows > -1) return $this->Num_Rows;
    if ($this->Last_SQL_Paging):
      $num_rows = -1;
      $query_count = stristr($this->Query_String," from "); 
      $query_count = "SELECT COUNT(*)".stristr($this->Query_String," from ");
      $query_count = ERegi_Replace("SELECT (.*) ORDER BY (.*)", "SELECT \\1", $query_count);
      //echo "<br>QUERY_COUNT: ".$query_count."<br>";
      $query_count = str_replace("\\", "\\\\", $query_count);

      $qid = pg_Exec($this->Link_ID, $query_count);
      if ($qid):
        $arr = pg_fetch_row($qid, 0);
        if ($arr):
          $num_rows = $arr[0];
        endif;
      endif; 
      pg_FreeResult($qid);
    else:
      $num_rows = pg_numrows($this->Query_ID);
    endif; 
    $this->Num_Rows = $num_rows;
    return $num_rows;
  }

  function num_fields() {
    return pg_numfields($this->Query_ID);
  }

  function nf() {
    return $this->num_rows();
  }

  function np() {
    print $this->num_rows();
  }

  function f($Name) {
    return $this->Record[$Name];
  }

  function p($Name) {
    print $this->Record[$Name];
  }
  
  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      if ($this->ShowError):
        printf("</td></tr></table><br><b>Database error:</b> %s<br>\n", $msg);
        printf("<b>PostgreSQL Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
        if($this->Error_Die) die("Application error: bad SQL.");
      endif;
    }
    else if($this->Error_Die) die();
  }

  function table_names() {
    $this->query("select relname from pg_class where relkind = 'r' and not relname like 'pg_%'");
    $i=0;
    while ($this->next_record())
     {
      $return[$i]["table_name"]= $this->f(0);
      $return[$i]["tablespace_name"]=$this->Database;
      $return[$i]["database"]=$this->Database;
      $i++;
     }
    return $return;
  }

  function getlastid($table, $fieldname) {
    $oid = PG_GetLastOID($this->Query_ID);
    if (strcasecmp($fieldname,"OID") == 0):
      return $oid;
    else:
      if($oid) $id = @pg_Exec($this->Link_ID, "select $fieldname from $table where OID = $oid");
      if ($id):
        $arr = @pg_fetch_row($id, 0);
        if ($arr) {
          return $arr[0];
        } else {
          return false;
        }
      else: 
        return false;
      endif;
    endif;
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $arrDate = Explode(" ",$date);
      $tok = Explode("-",$arrDate[0]);
      if ($this->Date_Format == "Y-m-d") {
        //$time = MkTime(0,0,0,$tok[1],$tok[2],$tok[0]);
        $res = $tok[2].".".$tok[1].".".$tok[0];
      } else {
        //$time = MkTime(0,0,0,$tok[0],$tok[1],$tok[2]);
        $res = $tok[1].".".$tok[0].".".$tok[2];
      }
      //$res = Date("d.m.Y", $time);
      if ($removenull):
      
        $res = EReg_Replace("[.]0",".", $res);
        $res = EReg_Replace("^0","", $res);
      endif;
    else:
      $res = $empty;
    endif;
    return $res;
  }
  
  function str2dbdate ($date, $empty="")
  {
    $res = $empty;
    if ($date):
      $exp = Explode(" ",$date);
      $tok = Explode(".",$exp[0]);
      $res = $tok[2]."-".$tok[1]."-".$tok[0];
      if($exp[1]) $res.=' '.$exp[1]; //poke je i cas
    endif;
    return $res;
  }
  
  function date2dbdate ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date($this->Date_Format, $time);
    else:
      return $empty;
    endif;
  }

  function time2dbtime ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date($this->Time_Format, $time);
    else:
      return $empty;
    endif;
  }
  
}
?>
