<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_oqlds.inc,v 1.4 2008/01/07 08:38:16 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/http.inc"));
require_once($GLOBALS["TMAPY_LIB"].'/lib/xmlize/XMLize.php');
//require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");

class DB_Sql_OQLDS {
  var $Host     = "";
  var $User     = "";
  var $Password = "";
  var $Port = 8083;
  var $Encoding = 'Windows-1250';

  var $Link_ID  = 0;
  var $Query_ID = 0;
  var $Record   = array();
  var $Row      = 0;
  var $Date_Format = "Y-m-d";
  var $Time_Format = "H:i:s";
  var $TrimStrings = false;

  var $ShowError = true;
  var $Errno    = 0;
  var $Error    = "";
  var $Error_Die = true;

  var $Num_Rows = 0;
  var $SQL_Paging = 1;
  var $Last_SQL_Paging = 0;

  var $Query_String = "";
  var $Query_XML = "";
  var $metaquery = array();
  var $metafields = array();
  var $Record_Line = '';

  var $Fce_Like = "LIKE";
  var $Fce_Upper = "UPPER";

  var $Seek_Support = false; //zatim nedodelana podpora pro SEEK
  var $Result_stack = array();
//  var $Auto_Free = false;


  function connect() {

    if ( 0 == $this->Link_ID ) {

      if($this->Host && ereg('^http://(.*):([0-9]+)(/.*$)',$this->Host, $arr)){
        $this->HostName = $arr[1];
        $this->Port = $arr[2];
        $this->URI = $arr[3];
      }

      if(!$this->HostName) $this->halt("HTTP connection open - missing HostName");

      $this->http_connection = new http_class;

      $this->Error = $this->http_connection->Open(array("HostName"=>$this->HostName, "HostPort"=>$this->Port, "HostTimeOut"=>1));

      if ($this->Error)
        $this->halt("HTTP connection open");
      else
        $this->Link_ID = 1;
    }

  }


  function query_page($Query_String, $offset, $count) {

    $Offset = $offset;
    $PageSize = $count;

    $Query_XML = '<?xml version="1.0" encoding="'.$this->Encoding.'" ?>';
    $Query_XML.= '<Request><Security><User>'.$this->User.'</User><Password>'.$this->Password.'</Password></Security>';
    $Query_XML.= '<select><CmdText>'.$Query_String.'</CmdText><Offset>'.$Offset.'</Offset><PageSize>'.$PageSize.'</PageSize><Encoding>'.$this->Encoding.'</Encoding><CalcPageCount/><DelimitedTextResponse/>';
    $Query_XML.= '</select></Request>';

    $this->query($Query_String, $Query_XML);

    $this->Last_SQL_Paging = 1;

    return $this->Query_ID;
  }


  function query($Query_String, $Query_XML='') {

    $this->Query_String = $Query_String;
    $this->Query_XML = $Query_XML;
    $this->Result_stack = array ();
    $this->Row = 0;

    if(!$this->Query_XML){

      $PageNo = 0;
      $PageSize = 0;

      $this->Query_XML = '<?xml version="1.0" encoding="'.$this->Encoding.'" ?>';
      $this->Query_XML.= '<Request><Security><User>'.$this->User.'</User><Password>'.$this->Password.'</Password></Security>';
      $this->Query_XML.= '<select><CmdText>'.$Query_String.'</CmdText><PageNo>'.$PageNo.'</PageNo><PageSize>'.$PageSize.'</PageSize><Encoding>'.$this->Encoding.'</Encoding><CalcPageCount/><DelimitedTextResponse/>';
      $this->Query_XML.= '</select></Request>';
    }

    $this->connect();

    //die('<xmp>'.$this->Query_XML.'</xmp>');

    $this->Error = $this->http_connection->SendRequest(array(
                 "RequestMethod" => "POST",
                 "RequestURI"    => $this->URI,
                 "Headers"=>array(
                  "User-Agent" => "Mozilla/4.5 [en] (WinNT; I)",
                  "Pragma"     => "no-cache",
                  "Content-type" => "charset=" . $this->Encoding, 
                 ),
                 "PostValues"=>array(
                   "XMLrequest" => $this->Query_XML,
                 )
    ));

    if ($this->Error) $this->halt("HTTP SendRequest");

    $this->headers=array();

    $this->Error = $this->http_connection->ReadReplyHeaders(&$this->headers);

    if ($this->Error) $this->halt("HTTP ReadReplyHeaders");
    //print_r($this->headers);

    //prvni 4 radky jsou ruzne meta informace
    $line1 = $this->Next_Line(); //appName|pageNo|pageSize|pageCount|pageRecCount|fullRecCount
    $line2 = $this->Next_Line(); //OQLDS_UIR|1|25|-1|8|65455
    $line3 = $this->Next_Line(); //Id|Stav|VznikDne|VznikInfo|Nazev|ZanikDne|Zkratka|ZanikInfo
    $line4 = $this->Next_Line(); //Integer|int|Date|String|String|Date|String|String
    //echo "$line1<br>$line2<br>$line3<br>$line4<br>\n";
    $arr1 = explode('|',$line1);
    $arr2 = explode('|',$line2);
    $arr3 = explode('|',$line3);
    $arr4 = explode('|',$line4);

    if(strstr($arr1[0],'Error')){
      $this->Error = $arr1[1];
      $this->halt($arr1[2]);
      $ret = false;
    }elseif($line1){
      $ret = true;
    }else{
      $ret = true;
    }

    $this->metaquery = array();

    foreach($arr1 as $f){
      $this->metaquery[trim($f)] = trim(current($arr2));
      next($arr2);
    }

    foreach($arr3 as $f){
      $this->metafields[trim($f)] = trim(current($arr4));
      next($arr4);
    }

    $this->Num_Rows = (integer) $this->metaquery['fullRecCount'];//pageRecCount fullRecCount

    $this->Query_ID = $ret;
//print_r($this->metafields);
    return $ret;

  }


  function Close_Connection(){
	  $this->http_connection->Close();
  	$this->Link_ID = 0;
    $this->Result_stack = array();
  }


  function Next_Line(){
    if(!feof($this->http_connection->connection)) {
       $line = fgets($this->http_connection->connection, 4096);
       $line = UrlDecode($line);
    }else{
      $line = false;
    }
    return $line;
  }


  function next_record() {

    $stat = false;
    $this->Record = array();

    if (($this->Row + 1) > count ($this->Result_stack) ){

      if($line = $this->Next_Line()) {

         $this->Record_Line = $line;
         //echo $line."<br><br>";

         $arr = explode('|',$line);
         $i = 0;

         foreach($this->metafields as $k => $v){
           $fval = trim(current($arr));
           switch(strtolower($v)){
             case 'int':
             case 'integer': $ftype = $v;
             default: $ftype = '';
           }

           if($ftype) settype($fval, $ftype);

           $this->Record[$i++] = $fval;
           $this->Record[$k] = $fval;
           $this->Record[strtoupper($k)] = $fval;
           next($arr);
         }

         //Seek_support
         if (!$this->Row || $this->Seek_Support)
           $this->Result_stack[] = $this->Record;
         $this->Row += 1;
         $stat = true;
      }
    }
	  else{
      $this->Record = $this->Result_stack[$this->Row];
      $this->Row += 1;
	    $stat = true;
	  }

    if(!$stat) $this->Close_Connection();

    return $stat;
  }



  function seek($pos) {
// echo "SEEK:".$pos;//print_r($this->Result_stack);
    end ($this->Result_stack);
    $last_key = key ($this->Result_stack);
    reset ($this->Result_stack);

    if ($pos > $last_key) {
      while ($last_key < $pos) {
	      if (!$this->next_record()) {
      	  if ($this->Auto_commit) $this->commit();
          $this->halt("seek($pos) failed: result has ".$this->num_rows()." rows");
      	  return 0;
      	}
      	$last_key++;
      }
    }
    else {
      $this->Row = $pos;
    }
    $this->Row = $pos;
    return 1;
  }


  function metadata($table) {
    $i = 0;
    $met = '';
    $res   = array();
/*
    $client = new soapclient('http://elros.praha.tmapy.cz:8083/oqlds_uir/services/oqlds?wsdl');

    $met = $client->call('getClassMetadata', array('user' => $this->User,
                                                   'pswd' => $this->Password,
                                                   'className' => $table
                                                  )
                        );
*/

    $this->Query_XML_met = '<?xml version="1.0" encoding="'.$this->Encoding.'" ?>';
    $this->Query_XML_met.= '<Request><Security><User>'.$this->User.'</User><Password>'.$this->Password.'</Password></Security>';
    $this->Query_XML_met.= '<AdminCmd>class metadata '.$table.'</AdminCmd></Request>';

    $this->connect();

    //die('<xmp>'.$this->Query_XML_met.'</xmp>');

    $this->Error = $this->http_connection->SendRequest(array(
                 "RequestMethod" => "POST",
                 "RequestURI"    => $this->URI,
                 "Headers"=>array(
                  "User-Agent" => "Mozilla/4.5 [en] (WinNT; I)",
                  "Pragma"     => "no-cache",
                  "Content-type" => "charset=" . $this->Encoding,
                 ),
                 "PostValues"=>array(
                   "XMLrequest" => $this->Query_XML_met,
                 )
    ));

    if ($this->Error) $this->halt("HTTP SendRequest");

    $this->headers=array();

    $this->Error = $this->http_connection->ReadReplyHeaders(&$this->headers);

    if ($this->Error) $this->halt("HTTP ReadReplyHeaders");

    while (true):
      $error = $this->http_connection->ReadReplyBody(&$body,1000);
      if($error!="" || strlen($body)==0) break;
      $met .= $body;
    endwhile;

    $this->Close_Connection();


    $xml_met = xmlize($met);
    //print_r($xml_met);
    // nazev tabulky v xmlize muze obsahovat nadrazene tridy (pr uir.dbo.Adresa)- lumo
    $meta_table_prefix = "";
    if (!$xml_met['Response']['#']['Data'][0]['#'][$table]) {
      foreach($xml_met['Response']['#']['Data'][0]['#'] as $meta_table_name => $meta_table) {
        if (ereg("\.$table$", $meta_table_name)) {
          $meta_table_prefix = ereg_replace("\.$table$", ".", $meta_table_name);
          break;
        }
      }
    }

    foreach($xml_met['Response']['#']['Data'][0]['#'][$meta_table_prefix . $table][0]['#']['property'] as $field_info){

      $res[$i]['table'] = $table;
      $res[$i]['name'] = strtoupper($field_info['@']['name']);
      if($field_info['@']['isEntity']=="true") $res[$i]['origtype'] = $field_info['@']['valueClassID'];
        else
        $res[$i]['origtype'] = $field_info['@']['valueClass'];

      $arr = explode('.', $res[$i]['origtype']);
      $res[$i]['type'] = $arr[2];
      if($res[$i]['type']=="Character") $res[$i]['type']="char";
      if($res[$i]['type']=="Long") $res[$i]['type']="integer";
      $res[$i]['len'] = 15;

      $res[$i]['null'] = $field_info['@']['isNullable'];

      $res[$i]['flags'] = 0;

      $i++;
    }
//print_r($res);
    return $res;
  }


  function num_rows() {
    return $this->Num_Rows;
  }

  function nf() {
    return $this->num_rows();
  }

  function np() {
    print $this->num_rows();
  }

  function f($Name) {
    return $this->Record[$Name];
  }

  function p($Name) {
    print $this->Record[$Name];
  }


  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      if ($this->ShowError):
        printf("</td></tr></table><br><b>Database error:</b> %s<br>\n", $msg);
        printf("<b>OQLDS Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
        if($this->Error_Die) die("Application error: bad SQL.");
      endif;
    }
    else if($this->Error_Die) die();
  }


  function getlastid($table, $fieldname) {
  }


  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $arrDate = Explode("T",$date);
      $tok = Explode("-",$arrDate[0]);
      if ($this->Date_Format == "Y-m-d") {
        //$time = MkTime(0,0,0,$tok[1],$tok[2],$tok[0]);
        $res = $tok[2].".".$tok[1].".".$tok[0];
      } else {
        //$time = MkTime(0,0,0,$tok[0],$tok[1],$tok[2]);
        $res = $tok[1].".".$tok[0].".".$tok[2];
      }
      //$res = Date("d.m.Y", $time);
      if ($removenull):

        $res = EReg_Replace("[.]0",".", $res);
        $res = EReg_Replace("^0","", $res);
      endif;
    else:
      $res = $empty;
    endif;
    return $res;
  }


  function str2dbdate ($date, $empty="")
  {echo "aaaaaaaaa";
    $tok = Explode(".",$date);
//    $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    if ($date)
      {echo $tok[2]."-".$tok[1]."-".$tok[0]; return $tok[2]."-".$tok[1]."-".$tok[0];}
    else
      return $empty;
  }


  function date2dbdate ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1):
      return Date($this->Date_Format, $time);
    else:
      return $empty;
    endif;
  }


  function time2dbtime ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1):
      return Date($this->Time_Format, $time);
    else:
      return $empty;
    endif;
  }

}
?>
