<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_ogr.inc,v 1.13 2007/11/13 11:10:09 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */
include_once ($GLOBALS["TMAPY_LIB"].'/db/db_mapmain.inc');

class DB_Sql_OGR extends DB_Sql_MapMain {
  var $Database     = "";
  var $Auto_Free     = 1;     
  var $OGR_Extension = false;     
//  var $MapScript_Extension = 'php_mapscript48_ows.so';     
  var $SRS = NULL;     
  var $UpdateSupport = false;
  var $Date_Format = "Y-m-d";
  var $Time_Format = "H:i:s";  
  
  function connect() {
    if (!$this->connected) {
      $ext = $this->OGR_Extension?$this->OGR_Extension:((PHP_OS == "WINNT" || PHP_OS == "WIN32")?'php_ogr.dll':'php_ogr.so');
      if (!function_exists('OGRRegisterAll')) {
        dl($ext);
      }
      OGRRegisterAll();
      if (!$this->hDatasource) {
        $hSFDriver=NULL;
        @$this->hDatasource = OGROpen($this->Database, $this->UpdateSupport, $hSFDriver);
      }
      $this->connected=true;
    }
  }

  function disconnect() {
    $this->free_result($this->Query_ID);
    if (gettype($this->hDatasource)=='resource') {
      // TOKR - does not work
      //OGR_DS_Destroy($this->hDatasource);
      //unset($this->hDatasource);
      //$this->connected=false;
    }
  }

  function free_result($id=0){
    if ($id && $this->Query_Handlers['spatialfilter']) OGR_G_DestroyGeometry($this->Query_Handlers['spatialfilter']);;
    unset($this->Query_Handlers);
    if ($id && $this->hDatasource) @OGR_DS_ReleaseResultSet($this->hDatasource,$id);;
  }
  
  function query($Query_String) {
    $this->connect();
    $this->Num_Rows = -1;
    if ($this->Query_ID && $this->Auto_Free) $this->free_result($this->Query_ID);
    
    if ($this->Debug) printf("Debug: query = %s<br>\n", $Query_String);

    if (preg_match('/^[ ]*SELECT/', $Query_String)) {
      $this->Query_ID = $this->_querySelect($Query_String);
    } else if (preg_match('/^[ ]*INSERT/', $Query_String)) {
      $this->Query_ID = ($this->_queryInsert($Query_String) == OGRERR_NONE)?true:false;
    } else if (preg_match('/^[ ]*UPDATE/', $Query_String)) {
      $this->Query_ID = ($this->_queryUpdate($Query_String) == OGRERR_NONE)?true:false;
    } else if (preg_match('/^[ ]*DELETE/', $Query_String)) {
      $this->Query_ID = ($this->_queryDelete($Query_String) == OGRERR_NONE)?true:false;
    }
    
    return $this->Query_ID;    
  }
  
  function next_record() {
    $this->Record=array();
    $this->Row++;
    while (true) {
      $hFeature = OGR_L_GetNextFeature($this->Query_ID);
      if ($hFeature == NULL) {
        if ($this->Auto_Free && !$this->NextRecordCountOnly) $this->free_result($this->Query_ID);
        return false;
      }
      $fid = OGR_F_GetFID($hFeature);
      if ($this->Query_Handlers['where_fids'] && !In_array($fid,$this->Query_Handlers['where_fids'])) {
        OGR_F_Destroy($hFeature);
        continue;
      }
      if ($this->Query_Handlers['spatialfilter'] && !$this->_Intersect($this->Query_Handlers['spatialfilter'], OGR_F_GetGeometryRef ($hFeature))) {
        OGR_F_Destroy($hFeature);
        continue;
      }
      if ($this->NextRecordCountOnly) {
        OGR_F_Destroy($hFeature);
        break;
      }
      if (!$this->Query_Handlers['met']) {
        $this->_metadataForLayer(&$this->Query_Handlers);
      }
      foreach ($this->Query_Handlers['met'] as $key=>$val) {
        $fld = StrToUpper($val['name']);
        if ($val['name'] == 'FID_') { 
          $this->Record['FID_'] = $fid+1;
        } elseif ($val['name'] == 'FTYPE_') { 
          $geom = OGR_F_GetGeometryRef ($hFeature);
          if ($geom)
            $this->Record['FTYPE_'] = OGR_G_GetGeometryName($geom);
          else 
            $this->Record['FTYPE_'] = $this->DefaultGeometryType;
        } elseif ($val['name'] == 'FWKT_') {
          if (!$this->parse['select_wkt']) continue;
          $geom = OGR_F_GetGeometryRef ($hFeature);
          if ($geom) {
            $msshp = $this->_convertOgrShpToMsShp($geom,true);
            $this->Record['FWKT_'] = $msshp->toWkt();
          }
          $msshp->free;
        } else {
          switch ($val['type']) {
            case 'integer':
              $this->Record[$fld] = OGR_F_GetFieldAsInteger($hFeature, $key);  
            break; 
            case 'double':
              $this->Record[$fld] = OGR_F_GetFieldAsDouble($hFeature, $key);  
            break;
            case 'string':
            default:
              $this->Record[$fld] = OGR_F_GetFieldAsString($hFeature, $key);  
            break;
          }
        }
      }
      OGR_F_Destroy($hFeature);
      break;
    } 
    return true;
  }
  
  function Tran_Begin(){
    if ($this->Query_ID) OGR_L_StartTransaction ($this->Query_ID); 
  }

  function Tran_Commit(){
    if ($this->Query_ID) OGR_L_CommitTransaction ($this->Query_ID); 
  }
  
  function Tran_Rollback(){
    if ($this->Query_ID) OGR_L_RollbackTransaction ($this->Query_ID); 
  }   

  function seek($pos) {
    if ($this->Query_ID) {
      if ($pos < $this->Row) {
        OGR_L_ResetReading($this->Query_ID);
        $this->Row = 0;
      }
  		$this->NextRecordCountOnly = true;
      while (($this->Row < $pos) && $this->next_record()) $this->Row++;
  		$this->NextRecordCountOnly = false;
  	}
  }
  
  function metadata($table) {
    $layer = $this->_GetLayer($table);
    $met = $this->_MetadataForLayer(&$layer);
    return $met;
  }
  
  function affected_rows() {
  }
  
  function num_rows() {
    if ($this->Query_ID && !isset($this->Query_Handlers['num_rows'])) {
      $this->Query_Handlers['num_rows'] = 0;
      $row = $this->Row;
  		$this->seek(0);
  		$this->NextRecordCountOnly = true;
      while ($this->next_record()) $this->Query_Handlers['num_rows'] = $this->Query_Handlers['num_rows']+1;
  		$this->NextRecordCountOnly = false;
  		$this->seek($row);
  	}
  	return $this->Query_Handlers['num_rows'];
  }
  
  function num_fields() {
    return mssql_num_fields($this->Query_ID);
  }

  function nf() {
    return $this->num_rows();
  }
  
  function np() {
    print $this->num_rows();
  }
  
  function f($Field_Name) {
    return $this->Record[strtolower($Field_Name)];
  }
  
  function p($Field_Name) {
    print $this->f($Field_Name);
  }
  
  function getlastid($table, $fieldname) {
  }
  
  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      printf("</td></tr></table><b>Database error:</b> %s<br>\n", $msg);
      printf("<b>OGR Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
      die("Application error: bad SQL.");
    }
    else die();
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $tok = Explode("-",$date);
        $res = $tok[2].".".$tok[1].".".$tok[0];
      if ($removenull):
          $res = EReg_Replace("[.]0",".", $res);
          $res = EReg_Replace("^0","", $res);
      endif;
    else:
     $res = $empty;
    endif;
    return $res;
  }
  
  function date2dbdate ($time="", $empty="") {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date($this->Date_Format, $time);
    else:
      return $empty;
    endif;
  }

  function time2dbtime ($time="", $empty="") {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date($this->Time_Format, $time);
    else:
      return $empty;
    endif;
  }
  
  function dbdate2date ($date, $empty="") {
    $time = false;
    if ($date) {
      $tok = Explode('.',$this->dbdate2str($date));
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    }
    return $time;
  }  

  function _GetLayer($layername) {
    if (!$this->OGRLayers[$layername]) {
      if (!$this->hDatasource) {
        $hSFDriver=NULL;
        $this->hDatasource = OGROpen($this->Database, 0, $hSFDriver);
      }
      $hLayer = OGR_DS_GetLayerByName($this->hDatasource, $layername);
      $this->OGRLayers[$layername]['id'] = md5($layername);
      $this->OGRLayers[$layername]['name'] = $layername;
      $this->OGRLayers[$layername]['hLayer'] = $hLayer;
      if ($hLayer) {
        $this->OGRLayers[$layername]['hFDefn'] = OGR_L_GetLayerDefn($hLayer);
        $this->OGRLayers[$layername]['field_count'] = OGR_FD_GetFieldCount($this->OGRLayers[$layername]['hFDefn']);
        $this->_querySelect('SELECT * FROM '.$layername);
        if ($this->next_record()) {
          $this->OGRLayers[$layername]['geom_type'] = strtolower($this->Record['FTYPE_']);
        } else {
          $this->OGRLayers[$layername]['geom_type'] = strtolower($this->DefaultGeometryType);
        }
      }
    }
    return $this->OGRLayers[$layername];
  } 
    
  function _MetadataForLayer($layer) {
    if ($layer['met']) {
      $met = $layer['met'];
    } elseif ($layer['hFDefn']) {
      $count = OGR_FD_GetFieldCount($layer['hFDefn']);
      for ($i=0; $i<$count; $i++) {
        $hFldDefn = OGR_FD_GetFieldDefn($layer['hFDefn'], $i);
        $met[$i]['table'] = $layer['name'];
        $met[$i]['name'] = OGR_Fld_GetNameRef($hFldDefn); 
        $met[$i]['type'] = StrToLower(OGR_GetFieldTypeName(OGR_Fld_GetType($hFldDefn)));
        switch ($met[$i]['type']) {
          case 'real':
            $met[$i]['type'] = 'double';
          break;
        }
        $met[$i]['len'] = OGR_Fld_GetWidth($hFldDefn);
        $met[$i]['scale'] = OGR_Fld_GetPrecision($hFldDefn);
        $met[$i]['null'] = true;
      }
      $met[] = array('table'=>$layer['name'], 'name'=>'FWKT_', 'type'=>'integer', 'len'=>16);
      $met[] = array('table'=>$layer['name'], 'name'=>'FTYPE_', 'type'=>'string', 'len'=>16);
      $met[] = array('table'=>$layer['name'], 'name'=>'FID_', 'type'=>'integer', 'len'=>16);
      $layer['met'] = $met;
    } else {
      $met = array();
    }
    return $met;
  }
  
  function _GetShapeFromText($text, $shapetype, $type) {
    $textcoords = Explode('|', $text);
    $coords = array();
    foreach ($textcoords as $tcoord) {
      $ecoord = Explode(':',$tcoord);
      $coords[] = array('x'=>$ecoord[0], 'y'=>$ecoord[1]);
    }
    $shp = $this->_GetShape(array(
      'type'=>strtolower($shapetype),
      $shapetype=>$coords
      ), $type
    );
    return $shp;
  }

  function _GetShape($shape, $type) {
    switch ($type) {
      case 'point':
        $shp = OGR_G_CreateGeometry(wkbPoint);
        OGR_G_SetPoint($shp,0,$shape[$shape['type']][0]['x'], $shape[$shape['type']][0]['y'],0);
        OGR_G_FlattenTo2D ($shp);
      break;
      case "line":
      case "polyline":
      case "linestring":
        $shp = OGR_G_CreateGeometry(wkbLineString);
        foreach ($shape[$shape['type']] as $val) {
          OGR_G_AddPoint($shp, $val['x'], $val['y'],0);
        }
        OGR_G_FlattenTo2D ($shp);
      break;
      case "polygon":
      case "rect":
        switch ($shape['type']) {
          case 'rect':
          case 'polygon':
          case 'circle':
            if (!$input_shp) $input_shp = $shape[$shape['type']];
            $shp = OGR_G_CreateGeometry(wkbPolygon);
            $hring = OGR_G_CreateGeometry(wkbLinearRing);
            foreach ($input_shp as $val) {
              @OGR_G_AddPoint($hring, $val['x'], $val['y'], 0);
            }
            OGR_G_FlattenTo2D ($hring);
            $eErr = OGR_G_AddGeometry($shp, $hring);
          break;
        }
      break;
    }
    return $shp; 
  }

  function _convertOgrShpToMsShp($shp,$forceshape=false) {
    if (!function_exists('ms_shapeObjFromWkt')) {
      $ext = $this->MapScript_Extension?$this->MapScript_Extension:((PHP_OS == "WINNT" || PHP_OS == "WIN32")?'php_mapscript48_ows.dll':'php_mapscript48_ows.so');
      dl($ext);
    }
    if ($shp) {
      switch (OGR_G_GetGeometryName($shp)) {
        case 'POINT':
          if ($forceshape) {
            $msShp = ms_shapeObjFromWkt('POINT('.OGR_G_GetX($shp,0).' '.OGR_G_GetY($shp,0).')');
          } else {
            $msShp =  ms_newPointObj();
            $msShp->setXY(OGR_G_GetX($shp,0),OGR_G_GetY($shp, 0));
          }
        break;
        case 'LINESTRING':
          $msShp = ms_newShapeObj(MS_SHAPE_LINE);
          $msLine =  ms_newLineObj();
          $cnt = OGR_G_GetPointCount($shp);
          for ($i=0; $i<$cnt; $i++) {
            $msLine->addXY(OGR_G_GetX($shp, $i),OGR_G_GetY($shp, $i));
          }
          $msShp->add($msLine);
        break;
        case 'LINEARRING':
          $msShp = ms_newShapeObj(MS_SHAPE_POLYGON);
          $msLine =  ms_newLineObj();
          $cnt = OGR_G_GetPointCount($shp);
          for ($i=0; $i<$cnt; $i++) {
            $msLine->addXY(OGR_G_GetX($shp, $i),OGR_G_GetY($shp, $i));
          }
          $msShp->add($msLine);
        break;
        case 'POLYGON':
        case 'MULTIPOLYGON':
          $msShp = ms_newShapeObj(MS_SHAPE_POLYGON);
          $gcnt = OGR_G_GetGeometryCount ($shp);
          for ($g=0; $g<$gcnt; $g++) { 
            $msLine =  ms_newLineObj();
            $gshp = OGR_G_GetGeometryRef($shp, $g);
            $cnt = OGR_G_GetPointCount($gshp);
            for ($i=0; $i<$cnt; $i++) {
              $msLine->addXY(OGR_G_GetX($gshp, $i),OGR_G_GetY($gshp, $i));
            }
            $msShp->add($msLine);
          }
        break;
        default:
          die(OGR_G_GetGeometryName($shp).' not supported in _convertShpToMsShp.');
        break;
      }
    }
    return $msShp;
  }
  //Spatial intersect
  function _Intersect($shp1, $shp2) {
    $msShp1 = $this->_convertOgrShpToMsShp($shp1);
    $msShp2 = $this->_convertOgrShpToMsShp($shp2);
    if ($msShp1 && $msShp2) {
      switch (get_class($msShp1)) {
        case 'ms_point_obj':
          switch (get_class($msShp2)) {
            case 'ms_point_obj':
              $ret = ($msShp1->x == $msShp2->x) && ($msShp1->y == $msShp2->y);
            break;
            default:
              $ret = $msShp2->contains($msShp1);
            break;
          }
        break;
        default:
          switch (get_class($msShp2)) {
            case 'ms_point_obj':
              $ret = $msShp1->contains($msShp2);
            break;
            default:
              $ret = $msShp1->intersects($msShp2);
            break;
          }
        break;
      }
      $msShp1->free();
      $msShp2->free();
    }
    return $ret;
  }
  
  function _querySelect($Query_String) {
    $sql = str_replace("\\", "\\\\", $Query_String);
    $shp = NULL;
    if (preg_match('/[, ]+FWKT_[, ]+/i', $sql)) {
      $sql = preg_replace('/[, ]+FWKT_[, ]+/i', ' ', $sql);
      $select_wkt = true;
    } 
    $this->PrepareParams($sql);
    $this->parse['select_wkt'] = $select_wkt?true:false;
    if ($this->parse['select_shape']) {
      switch ($this->parse['select_shape']['type']) {
        case 'bbox':
          $sql = Str_Replace($match_bbox[0],'', $sql);
          $bbox = Split('[ ]*,[ ]*', $this->parse['select_shape']['coords']);
          $shp = $this->_GetShape(array(
            'type'=>'rect',
            'rect'=>array(
              array('x'=>$bbox[0],'y'=>$bbox[3]),
              array('x'=>$bbox[2],'y'=>$bbox[3]),
              array('x'=>$bbox[2],'y'=>$bbox[1]),
              array('x'=>$bbox[0],'y'=>$bbox[1]),
              array('x'=>$bbox[0],'y'=>$bbox[3])
            ),
            ),'polygon'
          );
          $sql = Str_Replace($this->parse['select_shape']['wheretext'],'', $sql);
        break;
        default:
          $shp = $this->_GetShapeFromText($this->parse['select_shape']['coords'], $this->parse['select_shape']['type'], $this->parse['select_shape']['type']);
          $sql = Str_Replace($this->parse['select_shape']['wheretext'],'', $sql);
        break;
      }
    }
    if (preg_match('/FID_[ ]*(=|IN)[ (]*([^ )]+)[)]*[ ]*(AND){0,1}[ ]*/i', trim($sql), $match)) {
      $sql = Str_Replace($match[0], '', $sql);
      $this->Query_Handlers['where_fids'] = Explode(',', $match[2]);
      foreach ($this->Query_Handlers['where_fids'] as $key=>$val) {
        $this->Query_Handlers['where_fids'][$key] = $val-1;
      }
    }
    $sql = Preg_Replace('/WHERE$/','', trim($sql));
    $sql = Preg_Replace('/WHERE[ *]ORDER$/','ORDER', trim($sql));

    $this->Query_ID = OGR_DS_ExecuteSQL($this->hDatasource, $sql, $shp, NULL);
    if ($this->Query_ID) {
      $this->Query_Handlers['id'] = md5($Query_String);
      $this->Query_Handlers['hLayer'] = $this->Query_ID;
      $this->Query_Handlers['hFDefn'] = OGR_L_GetLayerDefn($this->Query_ID);
      $this->Query_Handlers['name'] = OGR_FD_GetName($this->Query_Handlers['hFDefn']);
      $this->Query_Handlers['spatialfilter'] = $shp;
  
      OGR_L_ResetReading($this->Query_ID);
    }
        
    $this->Row = 0;
    return $this->Query_ID;
  }

  function _queryInsert($Query_String) {
    $sql = str_replace("\\", "\\\\", $Query_String);
    if (preg_match('/[ ]*INSERT INTO (.+) \(TMS_SHAPE_TYPE[ ]*,[ ]*TMS_SHAPE_COORDS[ ]*,[ ]*(.+)\) VALUES \(([^,]+),[ ]*\(([-0-9.:|]+)\),[ ]*(.+)\)[ ]*/i', $sql, $parse)) {
      $layername = $parse[1];
      $lr = $this->_GetLayer($layername);
      if (!$lr['hLayer']) die('Cannot create Layer:'.$layername);
      $canedit = OGR_L_TestCapability($lr['hLayer'], OLCSequentialWrite);
      if ($canedit) {
  
        $met = $this->Metadata($layername);
        $fields = Explode(',', StrToUpper(Str_Replace(' ', '', $parse[2])));
        $fields[]='TMS_SHAPE_TYPE';
        $fields[]='TMS_SHAPE_COORDS';
        $values = Explode(',', $parse[5]);
        $values[]=$parse[3];
        $values[]=$parse[4];
        if ($this->_wait_for_unlock($layername)) {
          $this->_lock($layername);
          $hfeature = OGR_F_Create($lr['hFDefn']);
          $eErr = $this->_SetRecord($hfeature, $fields, $values, $met);
          if( $eErr != OGRERR_NONE ) return $eErr;
          $eErr = OGR_L_CreateFeature($lr['hLayer'], $hfeature);
          OGR_F_Destroy($hfeature);
          $this->_update_spatial_index($layername, $qix); 
          $this->_unlock($layername);
          if( $eErr != OGRERR_NONE ){
            printf("Error OGR_L_CreateFeature");
            return $eErr;
          }
        } else {
          die('ERROR: edit layer "'.$layername.'" is locked in "'.OGR_DS_GetName($this->hDatasource).'"');
        }
      } else {
        die('ERROR: cannot edit layer "'.$layername.'" in "'.OGR_DS_GetName($this->hDatasource).'"');
      }
    } else {
      die('ERROR in SQL: '.$sql);
    }
    return OGRERR_NONE;
  }

  function _queryUpdate($Query_String) {
    $sql = str_replace("\\", "\\\\", $Query_String);
    //echo($sql."<BR>\n");
    if (preg_match('/[ ]*UPDATE (.+) SET (.+) WHERE[ ]*FID_[ ]*=[ ]*(.+)/i', $sql, $parse)) {
      $layername = $parse[1];
      if ($this->_wait_for_unlock($layername)) {
        $this->_lock($layername);
        $lr = $this->_GetLayer($layername);
        if (!$lr['hLayer']) die('Cannot create Layer:'.$layername);
        $canedit = OGR_L_TestCapability($lr['hLayer'], OLCSequentialWrite);
        if ($canedit) {
          $met = $this->Metadata($layername);
          $values = array();
          $fields = array();
          if (preg_match_all('/([^, ]+[ ]*=[ ]*[^,"\']+)/i', $parse[2], $match)) {
            foreach ($match[0] as $item) {
              if (preg_match('/^([^=]+)=(.*)$/', $item, $match2)) {
                $fields[] = $match2[1];
                $values[] = $match2[2];
              }
            }
          }
          if (preg_match_all('/([^, ]+[ ]*=[ ]*["\'][^"\']*["\'])/i', $parse[2], $match)) {
            //print_r($match);
            foreach ($match[0] as $item) {
              if (preg_match('/^([^=]+)=(.*)$/', $item, $match2)) {
                $fields[] = $match2[1];
                $values[] = $match2[2];
              }
            }
          }
          $hfeature = OGR_L_GetFeature($lr['hLayer'], $parse[3]-1);
          $eErr = $this->_SetRecord($hfeature, $fields, $values, $met);
          if( $eErr != OGRERR_NONE ) return $eErr;
          OGR_L_SetFeature($lr['hLayer'], $hfeature);
          OGR_F_Destroy($hfeature);
        } else {
          $this->_unlock($layername);
          die('ERROR: cannot edit layer "'.$layername.'" in "'.OGR_DS_GetName($this->hDatasource).'"');
        }
        $this->_unlock($layername);
      } else {
        die('ERROR: edit layer "'.$layername.'" is locked in "'.OGR_DS_GetName($this->hDatasource).'"');
      }
    } else {
      die('ERROR in SQL: '.$sql);
    }
    return OGRERR_NONE;
  }

  function _queryDelete($Query_String) {
    $sql = str_replace("\\", "\\\\", $Query_String);
    if (preg_match('/[ ]*DELETE FROM (.+) WHERE FID_ IN \((.+)\)/i', $sql, $parse)) {
      $layername = $parse[1];
      if ($this->_wait_for_unlock($layername)) {
        $this->_lock($layername);
        $this->_CopyLayer($layername, $layername, Explode(',',$parse[2]-1));
        $this->_unlock($layername);
      } else {
        die('ERROR: edit layer "'.$layername.'" is locked in "'.OGR_DS_GetName($this->hDatasource).'"');
      }
    } else {
      die('ERROR in SQL: '.$sql);
    }
    return OGRERR_NONE;
  }
  
  function _SetRecord($hFeature, $fields, $values, $metadata) {
    foreach ($metadata as $key=>$val) {
      if (In_array($val['name'], $fields)) {
        $index = array_search($val['name'], $fields);
        $values[$index] = trim($values[$index]);
        if ($values[$index] == '***auto***') {
          $dsid = OGR_DS_ExecuteSQL($this->hDatasource, 'SELECT '.$val['name'].' FROM '.$val['table'], NULL, NULL);
          OGR_L_ResetReading($dsid);
          $max_id = 0;
          while (true) {
            $hf = OGR_L_GetNextFeature($dsid);
            if ($hf == NULL) break;
            $id = OGR_F_GetFieldAsInteger($hf, 0);
            if ($max_id < $id) $max_id = $id;
          }
          $values[$index] = $max_id+1;
          OGR_DS_ReleaseResultSet($this->hDatasource,$dsid);
        }
        if ($values[$index] == 'NULL') unset($values[$index]);
        switch ($val['type']) {
          case 'integer':
            OGR_F_SetFieldInteger($hFeature, $key, $values[$index]);  
          break; 
          case 'double':
            OGR_F_SetFieldDouble($hFeature, $key, $values[$index]);  
          break;
          case 'string':
          default:
            OGR_F_SetFieldString($hFeature, $key, Preg_replace('/^[\'"]*([^\'"]*)[\'"]*$/', '${1}', $values[$index]));  
          break;
        }
      }
    }
    $keyType = array_search('TMS_SHAPE_TYPE',$fields);
    $keyCoor = array_search('TMS_SHAPE_COORDS',$fields);
    if ($keyType !== false && $keyCoor !== false) {
      if ($this->OGRLayers[$metadata[0]['table']]['geom_type']) {
        $geom_type = $this->OGRLayers[$metadata[0]['table']]['geom_type'];
      } else {
        $geom_type = strtolower($this->DefaultGeometryType);
      }
      $hgeometry = $this->_GetShapeFromText($values[$keyCoor],$values[$keyType], $geom_type);
      if ($hgeometry) { 
        $eErr = OGR_F_SetGeometry($hFeature, $hgeometry);
      } else {
        printf("Error GetShapeFromText: ".$values[$keyType].' - '.$values[$keyCoor]);
        $this->_unlock($layername);
        return $eErr;
      }
      if( $eErr != OGRERR_NONE ){
          printf("Error OGR_F_SetGeometry");
          $this->_unlock($layername);
          return $eErr;
      }
      OGR_G_DestroyGeometry($hgeometry);
    } 
    return OGRERR_NONE;
  }
  
  function _getDriver ($name) {
    $hSFDriver = NULL;
    for( $i = 0; $i < OGRGetDriverCount() && $hSFDriver == NULL; $i++ ) {
       if( !strcasecmp(OGR_DR_GetName(OGRGetDriver($i)) , $name) ) 
         $hSFDriver = OGRGetDriver($iDriver);
    }  
    return $hSFDriver;
  }
  
  function _CopyLayer($from, $to, $skip_fid) {
    if (!Is_array($skip_fid)) $skip_fid = array();
    if ($from == $to) $toname = 'tmp_ogr_'.$to; else $toname=$to; 
    if( !OGR_DS_TestCapability( $this->hDatasource, ODsCCreateLayer ) ) {
      printf( "%s data source does not support layer creation.\n", OGR_DS_GetName($this->hDatasource) );
      return OGRERR_FAILURE;
    }
    $lr_from = $this->_GetLayer($from);
    $lr_to['hLayer'] = OGR_DS_CreateLayer( 
                          $this->hDatasource, 
                          $toname, 
                          OGR_L_GetSpatialRef($lr_from['hLayer']),
                          OGR_FD_GetGeomType($lr_from['hFDefn']),
                          NULL 
                        );
    if( $lr_to['hLayer'] == NULL ) return FALSE;
    for( $i=0; $i<OGR_FD_GetFieldCount($lr_from['hFDefn']); $i++ ) {
      if( OGR_L_CreateField( $lr_to['hLayer'], OGR_FD_GetFieldDefn( $lr_from['hFDefn'], $i), 0 /*bApproOK*/ ) != OGRERR_NONE )
        return OGRERR_FAILURE;
    } 
    OGR_L_ResetReading($lr_from['hLayer']);
    $lr_to['hFDefn'] = OGR_L_GetLayerDefn($lr_to['hLayer']);
    while( ($hFeature = OGR_L_GetNextFeature($lr_from['hLayer'])) != NULL ) {
      if (In_array(OGR_F_GetFID($hFeature), $skip_fid)) {
        OGR_F_Destroy($hFeature);
        continue;
      } 
      $hDstFeature = OGR_F_Create($lr_to['hFDefn']);
      if( OGR_F_SetFrom( $hDstFeature, $hFeature, FALSE /*bForgiving*/ ) != OGRERR_NONE ) {
        OGR_F_Destroy($hFeature);
        printf("Unable to translate feature %d from layer %s.\n",  
               OGR_F_GetFID($hFeature), OGR_FD_GetName($hFDefn) );
        return FALSE;
      }
      OGR_F_Destroy($hFeature);
      if( OGR_L_CreateFeature( $lr_to['hLayer'], $hDstFeature ) != OGRERR_NONE ) {
        OGR_F_Destroy($hDstFeature);
        return FALSE;
      }
      OGR_F_Destroy($hDstFeature);
    }
    if ($from == $to) {
      $dirname = OGR_DS_GetName($this->hDatasource);
      $dir = Dir($dirname);
      $qix = false;
      while (false !== ($f = $dir->read())) {
        if (Is_File($dirname.'/'.$f)) {
          if (preg_match('/^'.$from.'\.([^(lock)]*)$/',$f, $param)) {
            if ($param[1] == 'qix') $qix = true;
            unlink($dirname.'/'.$f);
          }
        }
      }
      $this->_update_spatial_index($toname, $qix);
      $dir->rewind();
      while (false !== ($f = $dir->read())) {
        if (Is_File($dirname.'/'.$f)) {
          if (preg_match('/^'.$toname.'(\..*)$/',$f, $res)) {
            rename($dirname.'/'.$f, $dirname.'/'.$to.$res[1]);
          }
        }
      }
      $dir->close;
    }
    return true;      
    
  }
  
  function _update_spatial_index($name, $force=0) {
    $exists = File_Exists(OGR_DS_GetName($this->hDatasource).'/'.$name.'.qix');
    if ($force || $exists) {
      if ($exists)
        OGR_DS_ExecuteSQL($this->hDatasource, 'DROP SPATIAL INDEX ON '.$name, NULL, NULL);
      OGR_DS_ExecuteSQL($this->hDatasource, 'CREATE SPATIAL INDEX ON '.$name, NULL, NULL);
    }
  }

  function _lock($name) {
    return touch(OGR_DS_GetName($this->hDatasource).'/'.$name.'.lock');
  }

  function _unlock($name) {
    return unlink(OGR_DS_GetName($this->hDatasource).'/'.$name.'.lock');
  }

  function _is_locked($name) {
    return file_exists(OGR_DS_GetName($this->hDatasource).'/'.$name.'.lock');
  }
  
  function _wait_for_unlock($name) {
    $i = 0;
    while ($i++ < 15 && $this->_is_locked($name)) {
      sleep(1);
    }
    return !($this->_is_locked($name));
  }

}
?>
