<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_odbc_mysql.inc,v 1.2 2003/11/21 12:47:47 jiva Exp $'.'$Name:  $';exit;}; /* HEADER */

class DB_Sql_ODBC_MySQL {
  var $Host     = "";
  var $Database = "";
  var $User     = "";
  var $Password = "";
  var $UseODBCCursor = 1;

  var $Link_ID  = 0;
  var $Query_ID = 0;
  var $Record   = array();
  var $Row      = 0;
  
  var $Errno    = 0;
  var $Error    = "";
  var $ShowError = true;
  var $Num_Rows = 0;

  var $Auto_Free = 0;     ## set this to 1 to automatically free results

  var $SQL_Paging = 1;
  var $Last_SQL_Paging = 0;
  var $Query_String = "";
	
  function connect() {
    if ( 0 == $this->Link_ID ) {
      $this->Link_ID=odbc_pconnect($this->Database, $this->User, $this->Password, $this->UseODBCCursor);
      if (!$this->Link_ID) {
        $this->halt("Link-ID == false, odbc_pconnect failed");
      }
    }
    $this->ShowError = $GLOBALS["PROPERTIES_DEBUG"]["SHOW_DATABASE_ERROR"];
  }

/*  function prepare($Query_String) {
    $this->connect();
    $this->Query_ID = odbc_prepare($this->Link_ID,$Query_String);
    return $this->Query_ID;
  }
*/
  
  function query_page($Query_String, $offset, $count) {
    if (!ERegi("DISTINCT", $Query_String)):
      $Query_String_Page = $Query_String." LIMIT $offset, $count";
  //    echo($Query_String_Page);
      $this->query($Query_String_Page);
      $this->Query_String = $Query_String;
      $this->Last_SQL_Paging = 1;
    else:
      $this->query($Query_String);
    endif;
    return $this->Query_ID;
  }
	
  function query($Query_String) {
    $this->connect();
    
#   printf("<br>Debug: query = %s<br>\n", $Query_String);

#   rei@netone.com.br suggested that we use this instead of the odbc_exec().
#   He is on NT, connecting to a Unix MySQL server with ODBC. -- KK
#    $this->Query_ID = odbc_prepare($this->Link_ID,$Query_String);
#    $this->Query_Ok = odbc_execute($this->Query_ID);
        
    $Query_String = str_replace("\\", "\\\\", $Query_String);
    
    $this->Num_Rows = -1;
    $this->Query_ID = odbc_exec($this->Link_ID,$Query_String);
//    $this->prepare($Query_String);
//    odbc_execute($this->Query_ID);

    $this->Row = 0;
    odbc_binmode($this->Query_ID, 1);
    odbc_longreadlen($this->Query_ID, 4096);
    
    if (!$this->Query_ID) {
      $this->Errno = 1;
      $this->Error = "General Error (The ODBC interface cannot return detailed error messages).";
      $this->halt("Invalid SQL: ".$Query_String);
      return false;
    }
    return $this->Query_ID;
  }
  
  function next_record() {
    $this->Record = array();
    $stat      = odbc_fetch_into($this->Query_ID, ++$this->Row, &$this->Record);
    if (!$stat) {
      if ($this->Auto_Free) {
	    odbc_free_result($this->Query_ID);
        $this->Query_ID = 0;
	  };
    } else {
      // add to Record[<key>]
      $count = odbc_num_fields($this->Query_ID);
      for ($i=1; $i<=$count; $i++):
        $this->Record[strtoupper(odbc_field_name ($this->Query_ID, $i)) ] = $this->Record[ $i - 1 ];
      endfor;
    }
    return $stat;
  }
  
  function seek($pos) {
    $this->Row = $pos;
  }

  function metadata($table) {
    $count = 0;
    $id    = 0;
    $res   = array();

    $this->connect();
    $id = odbc_exec($this->Link_ID, "DESCRIBE $table");
    if (!$id) {
      $this->Errno = 1;
      $this->Error = "General Error (The ODBC interface cannot return detailed error messages).";
      $this->halt("Metadata query failed.");
    }

    $i = 0;  
    while (odbc_fetch_row($id)) { 
      $res[$i]["table"] = $table;
      $res[$i]["name"]  = StrToUpper(odbc_result($id, "FIELD"));
      $type = odbc_result($id, "TYPE");
      EReg("^(.*)\((.*)\)$", $type, $typearr);
      $res[$i]["type"]  = $typearr[1];
      $typelen = Explode(",", $typearr[2]);
      $type = ""; $typearr = array();
      $res[$i]["len"]   = $typelen[0];
      $res[$i]["scale"] = $typelen[1];
      if (odbc_result($id, "NULL") == "YES")
        $res[$i]["null"] = 1;
      else
        $res[$i]["null"] = 0;
      $res[$i]["flags"] = 0;
      $res[$i]["autoincrement"] = ERegi("auto_increment", odbc_result($id, "EXTRA"));
      $i++;
    }

    odbc_free_result($id);
    return $res;
  }
  
  function affected_rows() {
    return odbc_num_rows($this->Query_ID);
  }
  
  function num_rows() {
    if ($this->Num_Rows > -1) return $this->Num_Rows;
    if ($this->Last_SQL_Paging):
      $num_rows = -1;
      $query_count = stristr($this->Query_String," from "); 
      $query_count = "SELECT COUNT(*) AS CNT".stristr($this->Query_String," from ");
      $query_count = ERegi_Replace("SELECT (.*) ORDER BY (.*)", "SELECT \\1", $query_count);
      $query_count = str_replace("\\", "\\\\", $query_count);

      $qid = odbc_exec($this->Link_ID, $query_count);
      if ($qid):
        $arr = odbc_fetch_row($qid);
        if ($arr):
          $num_rows = odbc_result($qid, "CNT");
        endif;
      endif; 
      odbc_Free_Result($qid);
//      die($num_rows);
    else:
  
      # Many ODBC drivers don't support odbc_num_rows() on SELECT statements.
      $num_rows = odbc_num_rows($this->Query_ID);
  	//printf ($num_rows."<br>");
  
      # This is a workaround. It is intended to be ugly.
      if ($num_rows < 0) {
        $i=10;
        while (odbc_fetch_row($this->Query_ID, $i)) 
          $i*=10;
  
        $j=0;
        while ($i!=$j) {
          $k= $j+intval(($i-$j)/2);
          if (odbc_fetch_row($this->Query_ID, $k))
            $j=$k;
          else 
            $i=$k;
          if (($i-$j)==1) {
            if (odbc_fetch_row($this->Query_ID, $i)) 
              $j=$i;
            else 
              $i=$j; 
          };
          //printf("$i $j $k <br>");
        };
        $num_rows=$i;
      }
		endif;	
    $this->Num_Rows = $num_rows;
    return $num_rows;
  }
  
  function num_fields() {
    return count($this->Record)/2;
  }

  function nf() {
    return $this->num_rows();
  }
  
  function np() {
    print $this->num_rows();
  }
  
  function f($Field_Name) {
    return $this->Record[strtolower($Field_Name)];
  }
  
  function p($Field_Name) {
    print $this->f($Field_Name);
  }

  function getlastid($table, $fieldname) {
    if ($this->query("select LAST_INSERT_ID()") && $this->next_record()):
      return $this->Record[0];
    else: 
      return false;
    endif;
  }
  
  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      if ($this->ShowError):
        printf("</td></tr></table><b>Database error:</b> %s<br>\n", $msg);
        printf("<b>ODBC Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
        die("Application error: bad SQL.");
      endif;
    }
    else die();
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $tok = Explode("-",$date);
      $time = MkTime(0,0,0,$tok[1],$tok[2],$tok[0]);
      if ($time > -1): 
        $res = Date("d.m.Y", $time);
        if ($removenull):
          $res = EReg_Replace("[.]0",".", $res);
          $res = EReg_Replace("^0","", $res);
        endif;
      else:
       $res = $empty;
      endif;
	  else:
       $res = $empty;
    endif;
    return $res;
  }
  
  function str2dbdate ($date, $empty="")
  {
    if ($date):
      $tok = Explode(".",$date);
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
      if ($time > -1): 
        $res = Date("Ymd", $time);
      else:
       $res = $empty;
      endif;
	  else:
       $res = $empty;
    endif;
    return $res;
  }
  
  function date2dbdate ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date("Ymd", $time);
    else:
      return $empty;
    endif;
  }
  
  function DB_ZeroFloat($t) {
    if (StrCmp($t[0],".")==0)
      return "0".$t;
    else
      return $t;
  }
  
}
?>
