<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_odbc_mssql.inc,v 1.4 2004/10/08 09:14:46 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class DB_Sql_ODBC_MSSQL {
  var $Host     = "";
  var $Database = "";
  var $User     = "";
  var $Password = "";
  var $UseODBCCursor = 0;

  var $Link_ID  = 0;
  var $Query_ID = 0;
  var $Record   = array();
  var $Row      = 0;
  
  var $Errno    = 0;
  var $Error    = "";
  var $ShowError = true;
  var $Num_Rows = 0;

  var $Auto_Free = 0;     ## set this to 1 to automatically free results

  var $SQL_Paging = 1;
  var $Last_SQL_Paging = 0;
  var $Query_String = "";
	
  function connect() {
    if ( 0 == $this->Link_ID ) {
      $this->Link_ID=odbc_pconnect($this->Database, $this->User, $this->Password, $this->UseODBCCursor);
      if (!$this->Link_ID) {
        $this->halt("Link-ID == false, odbc_pconnect failed");
      }
    }
    $this->ShowError = $GLOBALS["PROPERTIES_DEBUG"]["SHOW_DATABASE_ERROR"];
  }

/*  function prepare($Query_String) {
    $this->connect();
    $this->Query_ID = odbc_prepare($this->Link_ID,$Query_String);
    return $this->Query_ID;
  }
*/
  
  function query_page($Query_String, $offset, $count) {
    if (!$this->UseODBCCursor && !ERegi("DISTINCT", $Query_String)):
		  $Query_String_Page = ERegi_Replace("select ", "SELECT TOP ".($offset+$count)." ", $Query_String);
//      echo($Query_String_Page);
      $this->query($Query_String_Page);
      if ($this->Query_ID) {
			  $this->Row = $offset;
			}
      $this->Query_String = $Query_String;
      $this->Last_SQL_Paging = 1;
    else:
      $this->query($Query_String);
    endif;
    return $this->Query_ID;
  }

  function query($Query_String) {
    $this->connect();
    
#   printf("<br>Debug: query = %s<br>\n", $Query_String);

#   rei@netone.com.br suggested that we use this instead of the odbc_exec().
#   He is on NT, connecting to a Unix MySQL server with ODBC. -- KK
#    $this->Query_ID = odbc_prepare($this->Link_ID,$Query_String);
#    $this->Query_Ok = odbc_execute($this->Query_ID);
        
    $this->Num_Rows = -1;
    $this->Query_ID = odbc_exec($this->Link_ID,$Query_String);
//    $this->prepare($Query_String);
//    odbc_execute($this->Query_ID);

    $this->Row = 0;
    odbc_binmode($this->Query_ID, 1);
    odbc_longreadlen($this->Query_ID, 4096);
    
    if (!$this->Query_ID) {
      $this->Errno = 1;
      $this->Error = "General Error (The ODBC interface cannot return detailed error messages).";
      $this->halt("Invalid SQL: ".$Query_String);
      return false;
    }
    return $this->Query_ID;
  }
  
  function next_record() {
    $this->Record = array();
    $stat      = odbc_fetch_into($this->Query_ID, ++$this->Row, &$this->Record);
    if (!$stat) {
      if ($this->Auto_Free) {
	    odbc_free_result($this->Query_ID);
        $this->Query_ID = 0;
	  };
    } else {
      // add to Record[<key>]
      $count = odbc_num_fields($this->Query_ID);
      for ($i=1; $i<=$count; $i++):
        $this->Record[strtoupper(odbc_field_name ($this->Query_ID, $i)) ] = $this->Record[ $i - 1 ];
      endfor;
    }
    return $stat;
  }
  
  function seek($pos) {
    $this->Row = $pos;
  }

  function metadata($table) {
    $count = 0;
    $id    = 0;
    $res   = array();
    $ver   = 0; 

    $this->connect();
    $id = odbc_exec($this->Link_ID, "sp_server_info 500");
    if ($id) {
      if (odbc_fetch_row($id))
        $ver = odbc_result($id, "attribute_value");
      SetType($ver, "integer");
    }

    if ($ver < 7) {
      $id = odbc_exec($this->Link_ID, "select * from $table");
      if (!$id) {
        $this->Errno = 1;
        $this->Error = "General Error (The ODBC interface cannot return detailed error messages).";
        $this->halt("Metadata query failed.");
      }
      $count = odbc_num_fields($id);
      
      for ($i=1; $i<=$count; $i++) {
        $res[$i]["table"] = $table;
        $name             = odbc_field_name ($id, $i);
        $res[$i]["name"]  = $name;
        $res[$i]["type"]  = odbc_field_type ($id, $i);
        $res[$i]["len"]   = 0;  // can we determine the width of this column?
        $res[$i]["flags"] = ""; // any optional flags to report?
      }
    } else {
      $id2 = odbc_exec($this->Link_ID, "select name from syscolumns where id in (select id from sysobjects where name = '$table') and colstat = 1");
      if (odbc_fetch_row($id2)):
        $autoincrement = odbc_result($id2, "name");
      endif;
      $id = odbc_exec($this->Link_ID, "select * from INFORMATION_SCHEMA.COLUMNS where table_name = '$table'");
      $i = 0;  
      while (odbc_fetch_row($id)) { 
        $res[$i]["table"] = odbc_result($id, "TABLE_NAME");
        $res[$i]["name"]  = odbc_result($id, "COLUMN_NAME");
        $res[$i]["type"]  = odbc_result($id, "DATA_TYPE");
        $res[$i]["len"]   = odbc_result($id, "CHARACTER_MAXIMUM_LENGTH");
        if (odbc_result($id, "IS_NULLABLE") == "YES")
          $res[$i]["null"] = 1;
        else
          $res[$i]["null"] = 0;
        $res[$i]["flags"] = 0;
        if (!$res[$i]["len"]) {
          $res[$i]["len"]   = odbc_result($id, "NUMERIC_PRECISION");
          if (!odbc_result($id, "DATETIME_PRECISION")):
            $res[$i]["flags"] = 1;
            $res[$i]["autoincrement"] = StrCmp($res[$i]["name"], $autoincrement) == 0;
          else:
            $res[$i]["scale"]   = odbc_result($id, "NUMERIC_SCALE");
          endif;
        }
        $i++;
      }
    }  
    odbc_free_result($id);
    return $res;
  }
  
  function affected_rows() {
    return odbc_num_rows($this->Query_ID);
  }
  
  function num_rows() {
    if ($this->Num_Rows > -1) return $this->Num_Rows;
    if ($this->Last_SQL_Paging):
      $num_rows = -1;
      $query_count = stristr($this->Query_String," from "); 
      $query_count = "SELECT COUNT(*) AS CNT".stristr($this->Query_String," from ");
      $query_count = ERegi_Replace("SELECT (.*) ORDER BY (.*)", "SELECT \\1", $query_count);
      $qid = odbc_exec($this->Link_ID, $query_count);
      if ($qid):
        $arr = odbc_fetch_row($qid);
        if ($arr):
          $num_rows = odbc_result($qid, "CNT");
        endif;
      endif; 
      odbc_Free_Result($qid);
//      die($num_rows);
    else:
  
      # Many ODBC drivers don't support odbc_num_rows() on SELECT statements.
      $num_rows = odbc_num_rows($this->Query_ID);
  	//printf ($num_rows."<br>");
  
      # This is a workaround. It is intended to be ugly.
      if ($num_rows < 0) {
        $i=10;
        while (odbc_fetch_row($this->Query_ID, $i)) 
          $i*=10;
  
        $j=0;
        while ($i!=$j) {
          $k= $j+intval(($i-$j)/2);
          if (odbc_fetch_row($this->Query_ID, $k))
            $j=$k;
          else 
            $i=$k;
          if (($i-$j)==1) {
            if (odbc_fetch_row($this->Query_ID, $i)) 
              $j=$i;
            else 
              $i=$j; 
          };
          //printf("$i $j $k <br>");
        };
        $num_rows=$i;
      }
		endif;	
    $this->Num_Rows = $num_rows;
    return $num_rows;
  }
  
  function num_fields() {
    return count($this->Record)/2;
  }

  function nf() {
    return $this->num_rows();
  }
  
  function np() {
    print $this->num_rows();
  }
  
  function f($Field_Name) {
    return $this->Record[strtolower($Field_Name)];
  }
  
  function p($Field_Name) {
    print $this->f($Field_Name);
  }

  function getlastid($table, $fieldname) {
//    if ($this->query("SELECT @@IDENTITY AS 'IDENTITY'") && $this->next_record()):
    if ($this->query("SELECT SCOPE_IDENTITY() AS 'IDENTITY'") && $this->next_record()):
      return $this->Record["IDENTITY"];
    else: 
      return false;
    endif;
  }
  
  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      if ($this->ShowError):
        printf("</td></tr></table><b>Database error:</b> %s<br>\n", $msg);
        printf("<b>ODBC Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
        die("Application error: bad SQL.");
      endif;
    }
    else die();
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $tok = Explode("-",$date);
      $time = MkTime(0,0,0,$tok[1],$tok[2],$tok[0]);
      if ($time > -1): 
        $res = Date("d.m.Y", $time);
        if ($removenull):
          $res = EReg_Replace("[.]0",".", $res);
          $res = EReg_Replace("^0","", $res);
        endif;
      else:
       $res = $empty;
      endif;
	  else:
       $res = $empty;
    endif;
    return $res;
  }
  
  function str2dbdate ($date, $empty="")
  {
    if ($date):
      $tok = Explode(".",$date);
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
      if ($time > -1): 
        $res = Date("Ymd", $time);
      else:
       $res = $empty;
      endif;
	  else:
       $res = $empty;
    endif;
    return $res;
  }
  
  function date2dbdate ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date("Ymd", $time);
    else:
      return $empty;
    endif;
  }
  
  function dbdate2date ($date, $empty="")
  {
    $tok = Explode("-",$date);
    $time = MkTime(0,0,0,$tok[1],$tok[2],$tok[0]);
    return $time;
  }

  function DB_ZeroFloat($t) {
    if (StrCmp($t[0],".")==0)
      return "0".$t;
    else
      return $t;
  }
  
}
?>
