<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_mapserver.inc,v 1.4 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once ($GLOBALS["TMAPY_LIB"].'/ms/MapServer.inc');
include_once(FileUp2(".admin/functions_compare.inc"));
include_once ($GLOBALS["TMAPY_LIB"].'/db/db_mapmain.inc');

class DB_Sql_MapServer extends DB_Sql_MapMain {

  var $msobj;
  var $cache = array();
  var $CzechSort; // = "windows-1250";
  var $DecimalSeparator = ".";
  var $ShowError = true;
  var $Error_Die = false;
  var $FeatureLimit = 5000;
  
  function DB_Sql_MapServer ($data=false) {
    $prop = array(
      'server'=>$this->Server?$this->Server:'127.0.0.1',
      'project'=>$this->Database,
      'charset'=>$this->CharSetQuery
    );
    $this->msobj = new MS_MapServer($prop);
  }
	
  function connect() {
    return 1;
  }	
  
  function query($Query_String) {
  
//explode SELECTs
    Eregi('SELECT ([^ ]+) FROM ([^ ]*) (.*)', $Query_String, $parse);
    if (preg_match("/SELECT [^ ]+ FROM [^ ]+/",$parse[3])) {
      if(!Eregi('.*([ ]*SELECT [^ ]+ FROM ([^ ]*) (.*))(\),[0-9]+\))$', $parse[3], $sub_parse))
          Eregi('.*([ ]*SELECT [^ ]+ FROM [^ ]* .*)[)][^)]*$', $parse[3], $sub_parse);
      $this->query($sub_parse[1]);
      if($this->parse['select']['shape']) {
        //TODO: vyresit vypocet tvaru pres vsechny nalezene prvky (pro vyber vice prvky)
        $coords = $this->msobj->exclude_feature = array();
        foreach($this->msobj->result as $feature) {
          $coords[] = $feature['_SHAPE_COORDS_'];
          if(preg_match("/NEIGHBOURS/",$parse[0]))
            $this->msobj->exclude_feature[] = $feature['_FEATURE_SEGMENT_'];
        }
        $result['_SHAPE_COORDS_'] = Implode('&',$coords);
        $feature = $this->msobj->result[0];
        if($feature) {
          $result['_SHAPE_COORDS_'] = str_replace(array(' ',','),array('|',':'),Trim($result['_SHAPE_COORDS_']));
          $replacement = 'TMS_SHAPE_TYPE='.$this->msobj->result[0]['_SHAPE_TYPE_'].' AND TMS_SHAPE_COORDS='.$result['_SHAPE_COORDS_'];
        }
        else return 1;
      }
      if($replacement) {
        $Query_String = Str_Replace($sub_parse[1],$replacement,$parse[0]);
      }
    }
//--
  
    //print($Query_String.'<br>');
    $this->PrepareParams($Query_String);

    $prop_name = '<PropertyName>'.$this->met[0]['name'].'</PropertyName>'; //any attr. needed for MS WFS
    $wfs_filter = '<Filter>';
    
    //select by attr - DONE
    if($this->parse['where_attr']['name']) {
      $vals = Explode(',',$this->parse['where_attr']['value']);
      if($this->parse['where_attr']['multival'] && Count($vals)>1) {
         $vals = Explode(',',$this->parse['where_attr']['value']);
         $wfs_filter .= '<Or>';
         foreach($vals as $val)
            $wfs_filter .= '<PropertyIsEqualTo><PropertyName>'.$this->parse['where_attr']['name'].'</PropertyName><Literal>'.$val.'</Literal></PropertyIsEqualTo>';
         $wfs_filter .= '</Or>';
      }
      else 
        $wfs_filter .= '<PropertyIsEqualTo><PropertyName>'.$this->parse['where_attr']['name'].'</PropertyName><Literal>'.$this->parse['where_attr']['value'].'</Literal></PropertyIsEqualTo>';
    }
    //select by shape (can be with buffer) - DONE
    elseif($this->parse['select_shape']) {
      $wfs_filter .= $this->_getFilterByShape($this->parse['select_shape'],$prop_name);
    }

    $wfs_filter .= '</Filter>';

    $wfs_request = '<GetFeature service="WFS" version="1.0.0"><Query TypeName="'.$this->parse['from']['tables'][0].'">';
    $wfs_request .= $wfs_filter;
    $wfs_request .= '</Query></GetFeature>';
	//print($wfs_request);
    $this->msobj->result = $this->msobj->query_wfs_get_feature($wfs_request,$this->met);
    $this->exclude_feature = false;

    return 1; 
  }

  function seek($pos) {
    if ($this->Row != $pos) {
      Reset($this->msobj->result);
      $this->Row=0;
      for(; $this->Row<$pos; ) {
        $this->next_record();
      }
    }
  }
	
  function next_record() {
    if (!$this->Row++ && $this->num_rows()) {
      $this->Record = Current($this->msobj->result);
      $ok = 1;
    } else {
      if (Next($this->msobj->result)) {
        $this->Record = Current($this->msobj->result);
        $ok = 1;
      } else {
        $this->Record = array();
        $ok = 0;
      }
    }

    return $ok;
  }
	
  function num_rows() {
    if ($this->num_rows == -1) 
      $this->num_rows = Count($this->msobj->result);
    return $this->num_rows;
  }

  function metadata($table) {
    $met = $this->msobj->get_wfs_fields($table);
    return $met;
  }

  function halt($msg, $error=true) {
    if ($GLOBALS["Debug"]["arcims"] || $GLOBALS["PROPERTIES_DEBUG"]["SHOW_SQL"]) {
      if ($this->ShowError || !$error):
        $this->msobj->halt($msg, true, $error);
      endif;  
    }
    if ($error && $this->Error_Die) die();
  }
  
  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $res = $date;
	  else:
       $res = $empty;
    endif;
    return $res;
      
  }
  
  function str2dbdate ($date, $empty="")
  {
    if ($date):
      $res = $date;
	  else:
      $res = $empty;
    endif;
    return $res;
  }
  
  function dbdate2date ($date, $empty="")
  {
    $time = false;
    if ($date) {
      $tok = Explode('-',$this->dbdate2str($date));
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    }
    return $time;
  }

  function _getFilterByShape($SHAPE,$prop_name) {
    $filter = '';
    if(strtolower($SHAPE['type'])=='bbox') {
      $bbox = Explode(',',$SHAPE['coords']);
      $filter .= '<BBOX>'.$prop_name;
      $filter .= '<Box><coordinates>'.$bbox[0].','.$bbox[1].' '.$bbox[2].','.$bbox[3].'</coordinates></Box>';
      $filter .= '</BBOX>';
    }
    else {
      $points = '';
      $coords_pairs = Explode('|',$SHAPE['coords']);
      $coords_arr = array();
      $i = 0;
      foreach($coords_pairs as $pair) {
        $xy = Explode(':',$pair);
        $coords_arr[$i]['x'] = $xy[0];
        $coords_arr[$i]['y'] = $xy[1];
        $i++;
      }
      if(strtolower($SHAPE['type'])=='polyline') {
        //$shp_points_arr = array_slice($coords_arr,0,-1);
        //$points_arr = array_merge($shp_points_arr,array_slice(array_reverse($shp_points_arr),1));
        $points_arr = array_merge($coords_arr,array_reverse($coords_arr));
        $SHAPE['type'] = 'polygon';
      }
      else {
        $points_arr = $coords_arr;
      }
      foreach($points_arr as $point)
        $points .= $point['x'].','.$point['y'].' ';
      if($this->parse['neighbours'])
        $SHAPE['distance'] = '0.001';
      switch(strtolower($SHAPE['type'])) {
       case 'polygon':
       case 'circle':
         if($SHAPE['distance'])
          $filter .= '<DWithin>'.$prop_name.'<gml:Polygon><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>'.Trim($points).'</gml:coordinates></gml:LinearRing><gml:LinearRing><gml:coordinates>'.Trim($points).'</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon><Distance units="m">'.$SHAPE['distance'].'</Distance></DWithin>';
         else
          $filter .= "<Intersect>$prop_name<gml:Polygon><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>".Trim($points)."</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></Intersect>";
         break;
      //actually not used - polyline now by polygon
       case 'polyline':
         if($SHAPE['distance'])
          $filter .= '<DWithin>'.$prop_name.'<gml:LineString><gml:coordinates>'.Trim($points).'</gml:coordinates></gml:LineString><Distance units="m">'.$SHAPE['distance'].'</Distance></DWithin>';
         else
          $filter .= '<Intersect>'.$prop_name.'<gml:LineString><gml:coordinates>'.Trim($points).'</gml:coordinates></gml:LineString></Intersect>';
         break;
      //--
       case 'point':
          $filter .= '<DWithin>'.$prop_name.'<gml:Point><gml:coordinates>'.Trim($points).'</gml:coordinates></gml:Point><Distance units="m">'.($SHAPE['distance']?$SHAPE['distance']:'0.0001').'</Distance></DWithin>';
         break;
       default: break;
      }
    }
    return $filter;
  }
  
}
?>
