<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_mapscript.inc,v 1.1 2006/10/25 12:14:57 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class DB_Sql_MapScript {
  var $Database     = "";
  var $Auto_Free     = 1;     
  var $MapScript_Extension = 'php_mapscript483_basic.so';     
  
  function DB_Sql_MapScript() {
    $ext = $this->MapScript_Extension?$this->MapScript_Extension:((PHP_OS == "WINNT" || PHP_OS == "WIN32")?'php_mapscript48_basic.dll':'php_mapscript483_basic.so');
    if (!function_exists('ms_shapeObjFromWkt')) dl($ext);
  }

  function connect() {
    if (!$this->connected) {
      $this->msMap = ms_newMapObj('');
      $this->msMap->set('shapepath',$this->Database);
      $this->connected=true;
    } 
  }
  
  function free_result($id=0){
  }
  
  function query($Query_String) {
    $this->connect();
    $this->num_rows = -1;
    $this->_parseSQL($Query_String);
  }
  
  function next_record() {
  }
  
  function Tran_Begin(){
  }

  function Tran_Commit(){
  }
  
  function Tran_Rollback(){
  }   

  function seek($pos) {
  }
  
  function metadata($table) {
    $msLayer = ms_newLayerObj($this->msMap);
    $msLayer->set('data',$table);
    //print_r($msLayer);
    $msLayer->open();
    $msShp = $msLayer->getShape(-1, 0);
    var_dump($msShp);
    $met = array();
    $i = 0;
    foreach ($msShp->values as $key=>$val) {
      $met[$i]['table'] = $table;
      $met[$i]['name'] = StrToUpper($key);
      switch (getType($key)) {
        case 'integer': 
        case 'string':
        case 'double':
          $met[$i]['type'] = getType($key); 
        break; 
        default:
          $met[$i]['type'] = 'string'; 
        break;
      }
      $i++;
    } 
    $msShp->free();
    $msLayer->close();
    $msShp = null;
    $msLayer = null;
    return $met;
  }
  
  function affected_rows() {
  }
  
  function num_rows() {
  }
  
  function num_fields() {
    return mssql_num_fields($this->Query_ID);
  }

  function nf() {
    return $this->num_rows();
  }
  
  function np() {
    print $this->num_rows();
  }
  
  function f($Field_Name) {
    return $this->Record[strtolower($Field_Name)];
  }
  
  function p($Field_Name) {
    print $this->f($Field_Name);
  }
  
  function getlastid($table, $fieldname) {
  }
  
  function halt($msg) {
    if ($GLOBALS["Debug"]["sql"]) {
      printf("</td></tr></table><b>Database error:</b> %s<br>\n", $msg);
      printf("<b>MapScript Error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
      die("Application error: bad SQL.");
    }
    else die();
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $tok = Explode("-",$date);
        $res = $tok[2].".".$tok[1].".".$tok[0];
      if ($removenull):
          $res = EReg_Replace("[.]0",".", $res);
          $res = EReg_Replace("^0","", $res);
      endif;
    else:
     $res = $empty;
    endif;
    return $res;
  }
  
  function date2dbdate ($time="", $empty="")
  {
    if (!$time) $time = Time();
    if ($time > -1): 
      return Date("Ymd", $time);
    else:
      return $empty;
    endif;
  }
  
  function dbdate2date ($date, $empty="")
  {
    $time = false;
    if ($date) {
      $tok = Explode('.',$this->dbdate2str($date));
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    }
    return $time;
  }
  
  function _parseSQL($Query_String) {
    $this->parse = array();
    if (!Ereg('SELECT DISTINCT', $Query_String) && Eregi('SELECT (.*) FROM(.*)', $Query_String, $parse)) {
      //SELECT
      $this->parse['select']['text'] = Trim($parse[1]);
      if (Eregi('DISTINCT (.*)', $this->parse['select']['text'], $parse)) {
        $this->parse['select']['distinct'] = 1;
        $this->parse['select']['fields'] = Split(',[ ]*', $parse[1]);
      } else {
        $this->parse['select']['fields'] = Split(',[ ]*', $this->parse['select']['text']);
      }
      foreach($this->parse['select']['fields'] as $key => $val) {
        $val = StrToUpper($val);
        $this->parse['select']['fields'][$key] = $val;
        if ($val == '*') {
          unset($this->parse['select']['fields'][$key]);
          $this->parse['select']['all'] = true;
        }
        if ($val == '_SHAPE_') {
          $this->parse['select']['fields'][$key] = '#SHAPE#';
          $this->parse['select']['shape'] = true;
        }
        if ($val == '_ID_') {
          $this->parse['select']['fields'][$key] = '#ID#';
        }
        if ($val == '_ENVELOPE_') {
          unset($this->parse['select']['fields'][$key]);
          $this->parse['select']['envelope'] = true;
        }
      }
      reset($this->parse['select']['fields']);


      //REST
      $this->parse['from']['text'] = Trim($parse[2]);
      if (Eregi('(.*) WHERE (.*)', $this->parse['from']['text'], $parse)) {
        $this->parse['from']['text'] = Trim($parse[1]);
        $this->parse['where']['text'] = Trim($parse[2]);
        if (Eregi('(.*) ORDER BY (.*)', $this->parse['where']['text'], $parse)) {
          $this->parse['where']['text'] = Trim($parse[1]);
          $this->parse['orderby']['text'] = Trim($parse[2]);
        }
      } else {
        if (Eregi('(.*) ORDER BY (.*)', $this->parse['from']['text'], $parse)) {
          $this->parse['from']['text'] = Trim($parse[1]);
          $this->parse['orderby']['text'] = Trim($parse[2]);
        }
      }
      //FROM
      $this->parse['from']['tables'] = Split(',[ ]*', $this->parse['from']['text']);

      $met = $this->Metadata($this->parse['from']['tables'][0]);
      $sde_prefix = $met['_ID_']['sde_prefix'];

      //WHERE

      if (!$this->CaseSensitive) $this->parse['where'] = StrToUpper($this->parse['where']['text']);
      else $this->parse['where'] = $this->parse['where']['text'];
      if (Eregi('(AND|OR){0,1}[ (]*TMS_BBOX[ ]*=[ ]*[(]([^)]*)[)]',  $this->parse['where'], $match_bbox)) {
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_BBOX[ ]*=[ ]*[(][^)]*[)]', '', $this->parse['where']);
        $this->parse['bbox'] = Split('[ ]*,[ ]*', $match_bbox[2]);
      }
      if (Eregi('(AND|OR){0,1}[ (]*TMS_SHAPE_TYPE[ ]*=[ ]*([a-zA-Z]+)[ )]*',  $this->parse['where'], $match_type) &&
          Eregi('(AND|OR){0,1}[ (]*TMS_SHAPE_COORDS[ ]*=[ ]*([0-9:|]+)[ )]*',  $this->parse['where'], $match_coords) &&
          Eregi('(AND|OR){0,1}[ (]*TMS_WIDTH[ ]*=[ ]*([0-9]+)[ )]*',  $this->parse['where'], $match_width) &&
          Eregi('(AND|OR){0,1}[ (]*TMS_HEIGHT[ ]*=[ ]*([0-9]+)[ )]*',  $this->parse['where'], $match_height)
          ) {
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_SHAPE_TYPE[ ]*=[ ]*([a-zA-Z]+)[ )]*', '', $this->parse['where']);
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_SHAPE_COORDS[ ]*=[ ]*([0-9:|]+)[ )]*', '', $this->parse['where']);
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_WIDTH[ ]*=[ ]*([0-9]+)[ )]*', '', $this->parse['where']);
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_HEIGHT[ ]*=[ ]*([0-9]+)[ )]*', '', $this->parse['where']);
        include_once(FileUp2('.admin/map_functions.inc'));
        $SHAPE = array(
          "type"=>strtolower($match_type[2]),
          "coords"=>$match_coords[2]
        );
        Shape_PrepareShape($SHAPE, false, true, $match_bbox[2], $match_width[2], $match_height[2]);
        $this->parse['select_shape'] = $SHAPE;
      }

      /*
      if (Eregi('(AND|OR){0,1}[ (]*TMS_BUFFER[ ]*=[ ]*[(]([^)]*)[)]',  $this->parse['where'], $parse)) {
        $this->parse['where'] = Eregi_Replace('(AND|OR){0,1}[ (]*TMS_BUFFER[ ]*=[ ]*[(][^)]*[)]', '', $this->parse['where']);
        $this->parse['buffer'] = $parse[2];
      }
      */
      if (preg_match("/TMS_BUFFER_TARGET_LAYER=.+[ ]+AND[ ]+TMS_BUFFER_DISTANCE=[0-9\.\(\)]+/", $this->parse['where'], $match)) {
        $this->parse['buffer']['target_layer'] = preg_replace("/TMS_BUFFER_TARGET_LAYER=([\_a-zA-Z0-9]+)[ ]+AND[ ]+TMS_BUFFER_DISTANCE=[0-9\.\(\)]+/", "\\1", $match[0]);
        $this->parse['buffer']['distance'] = preg_replace("/TMS_BUFFER_TARGET_LAYER=[\_a-zA-Z0-9]+[ ]+AND[ ]+TMS_BUFFER_DISTANCE=\(?([0-9\.]+)\)?/", "\\1", $match[0]);
        $this->parse['where'] = preg_replace("/[ ]+(AND|OR)[ ]+TMS_BUFFER_TARGET_LAYER=[\_a-zA-Z0-9]+[ ]+AND[ ]+TMS_BUFFER_DISTANCE=[0-9\.\(\)]+/", "",  $this->parse['where']);
      }

      if (!$this->CaseSensitive) $this->parse['where'] = Eregi_Replace('([^ (]*)([ ]*([=><]| like | in |<>))', '##START##\\1##END##\\2', $this->parse['where']);
      $this->parse['where'] = Str_Replace("*", '%', $this->parse['where']);
      $this->parse['where'] = Str_Replace("&", '&amp;', $this->parse['where']);
      $this->parse['where'] = Str_Replace("'", '&apos;', $this->parse['where']);
      $this->parse['where'] = Str_Replace('"', '&quot;', $this->parse['where']);
      $this->parse['where'] = Str_Replace("<", '&lt;', $this->parse['where']);
//      $this->parse['where'] = Str_Replace(">", '&gt;', $this->parse['where']);
      $this->parse['where'] = Str_Replace(">", '&gt;', $this->parse['where']);

      if (!$this->CaseSensitive) {
        foreach($met as $val) {
          if ($val['type'] == 'string') {
            $this->parse['where'] = Str_Replace('##START##'.$val['name'].'##END##', 'UPPER('.$sde_prefix.$val['name'].')', $this->parse['where']);
            //$this->parse['where'] = Str_Replace('##START##'.$val['name'], 'UPPER('.$sde_prefix.$val['name'], $this->parse['where']);
            //$this->parse['where'] = Str_Replace($val['name'], $val['name'].')', $this->parse['where']);
          } else {
            $this->parse['where'] = Str_Replace('##START##'.$val['name'].'##END##', $sde_prefix.$val['name'], $this->parse['where']);
            //$this->parse['where'] = Str_Replace('##START##'.$val['name'], $sde_prefix.$val['name'], $this->parse['where']);
            //$this->parse['where'] = Str_Replace($val['name'].'##END##', $val['name'], $this->parse['where']);
          }
        }
      }

      if ($sde_prefix)
        $this->parse['where'] = Str_Replace('_ID_','OBJECTID', $this->parse['where']);
      else
        $this->parse['where'] = Str_Replace('_ID_','#ID#', $this->parse['where']);

//      $this->parse['where'] = Htmlentities($this->parse['where']);

      //ORDER BY
      $this->parse['orderby']['fields'] = Split(',[ ]*', $this->parse['orderby']['text']);
      foreach($this->parse['orderby']['fields'] as $key=>$val) {
        if (Eregi('(.*)[ ]*(desc)$',Trim($val), $parse)) {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($parse[1]), 'desc'=>1);
        } elseif (Eregi('(.*)[ ]*(asc)$',Trim($val), $parse)) {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($parse[1]), 'desc'=>0);
        } else {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($val));
        }
      }
      if ($this->parse['orderby']['fields'][0]['name']) {
        $order_by_name = $this->parse['orderby']['fields'][0]['name'];
        $order_by_desc = $this->parse['orderby']['fields'][0]['desc'];
      }
    }  
  }  

}
?>
