<?php
/* HEADER */ if (isSet($TWIST_FILE_INFO)) {echo __FILE__.': $Id: db_arcims.inc,v 1.15 2008/04/04 08:52:29 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once ($GLOBALS["TMAPY_LIB"].'/ms/ArcIMS.inc');
include_once(FileUp2(".admin/functions_compare.inc"));
include_once ($GLOBALS["TMAPY_LIB"].'/db/db_mapmain.inc');

class DB_Sql_ArcIMS extends DB_Sql_MapMain {

  var $msobj;
  var $cache = array();
  var $CzechSort; // = "windows-1250";
  var $DecimalSeparator = ".";
  var $ShowError = true;
  var $Error_Die = false;
  var $FeatureLimit = 5000;

  function DB_Sql_ArcIMS ($data=false) {
    $prop = array(
      'server'=>$this->Host?$this->Host:'127.0.0.1',
      'port'=>$this->Port?$this->Port:'80',
      'service_name'=>$this->Database,
      'charset'=>$this->CharSet,
      'charsetquery'=>$this->CharSetQuery,
      'charsetunicodeentities'=>isset($this->CharSetUnicodeEntities)?$this->CharSetUnicodeEntities:true,
      'servlet'=>$this->Servlet
    );
    if ($this->CharSet && !$this->CzechSort) {
      $this->CzechSort = $this->CharSet;
    } elseif (!$this->CzechSort) {
      $this->CzechSort = "windows-1250";
    }
    $this->msobj = new MS_ArcIMS($prop);
  }

  function connect() {
    return 1;
  }

  function query($Query_String) {
    //explode SELECTs
    if(!$this->direct_query) {
      Eregi('SELECT ([^ ]+) FROM ([^ ]*) (.*)', $Query_String, $parse);
      if (preg_match("/SELECT [^ ]+ FROM [^ ]+/",$parse[3])) {
        if(!Eregi('.*([ ]*SELECT [^ ]+ FROM ([^ ]*) (.*))(\),[-0-9.]+\))$', $parse[3], $sub_parse))
            Eregi('.*([ ]*SELECT [^ ]+ FROM [^ ]* .*)[)][^)]*$', $parse[3], $sub_parse);
        $this->query($sub_parse[1]);
        if($this->parse['select']['shape']) {
          $coords = array();
          foreach($this->msobj->result as $feature) {
            $coords[] = Trim($feature['_SHAPE_COORDS_']);
          }
          $result['_SHAPE_COORDS_'] = Implode('&',$coords);
          $feature = $this->msobj->result[0];
          if($feature) {
            $result['_SHAPE_COORDS_'] = str_replace(array(' ',','),array('|',':'),Trim($result['_SHAPE_COORDS_']));
            $replacement = 'TMS_SHAPE_TYPE='.$this->msobj->result[0]['_SHAPE_TYPE_'].' AND TMS_SHAPE_COORDS='.$result['_SHAPE_COORDS_'];
            $found_id = $feature['_ID_'];
          }
          else return 1;
        }
        if($replacement) {
          $Query_String = Str_Replace($sub_parse[1],$replacement,$parse[0]);
        }
      }
  //--
    
      $this->PrepareParams($Query_String);

      $arcxml  = '<ARCXML version="1.1"><REQUEST>'."\n";
      $arcxml .= '<GET_FEATURES outputmode="xml" compact="false"';
      $arcxml .= $this->FeatureLimit?' featurelimit="'.$this->FeatureLimit.'"':'';
      $arcxml .= $this->parse['select']['shape']?' geometry="true"':' geometry="false"';
      $arcxml .= $this->parse['select']['envelope']?' envelope="true"':' envelope="false"';
      $arcxml .= '>'."\n";
      $arcxml .= '<LAYER id="'.$this->parse['from']['tables'][0].'" />'."\n";
      $arcxml .= '<SPATIALQUERY subfields="'.($this->parse['select']['all']?'#ALL#':Implode(' ',$this->parse['select']['fields'])).'"';
      $add_where = array();
      if($this->parse['neighbours']) $add_where[] = $this->met['_ID_']['sde_prefix'].'OBJECTID NOT IN ('.$found_id.')';
      if($this->parse['where_attr']['name']) {
        $add_where[] = trim($this->parse['where_attr']['wheretext']); //just forward wheretext to ArcXML request    
  //       if($this->parse['where_attr']['multival'])
  //         $add_where[]=$this->parse['where_attr']['name'].' IN ('.$this->parse['where_attr']['value'].')';
  //       else {
  //         if ($this->parse['where_attr']['quoted']) {
  //           $add_where[]=$this->parse['where_attr']['name'].' '.$this->parse['where_attr']['operator'].' \''.$this->parse['where_attr']['value'].'\'';
  //         } else {
  //           $add_where[]=$this->parse['where_attr']['name'].' '.$this->parse['where_attr']['operator'].' '.$this->parse['where_attr']['value'];
  //         }
  //       }
      }
      if(Count($add_where)>0) {
        $arcxml .= ' where="'.Implode(' AND ',$add_where).'"';
        //$arcxml .= ' where="'.$this->parse['where_attr']['name'].'='.$this->parse['where_attr']['value'].'"';
      }
      $arcxml .= '>'."\n";
  
      if($this->parse['select_shape']) {
        $arcxml .= '<SPATIALFILTER relation="area_intersection">'."\n";
        $SHAPE = $this->parse['select_shape'];
        if(strtolower($SHAPE['type'])=='bbox') {
          $bbox = Explode(',',$SHAPE['coords']);
          $minx = Str_Replace('.',$this->DecimalSeparator,(string)$bbox[0]);
          $miny = Str_Replace('.',$this->DecimalSeparator,(string)$bbox[1]);
          $maxx = Str_Replace('.',$this->DecimalSeparator,(string)$bbox[2]);
          $maxy = Str_Replace('.',$this->DecimalSeparator,(string)$bbox[3]);
          $arcxml .= '<ENVELOPE minx="'.$minx.'" miny="'.$miny.'" maxx="'.$maxx.'" maxy="'.$maxy.'" />'."\n";
        }
        else {
          $points = array();
          $segments = Explode('&',$SHAPE['coords']);
          $coords_arr = array();
          for($h=0;$h<Count($segments);$h++) {
            $coords_pairs = Explode('|',$segments[$h]);
            $i=0;
            foreach($coords_pairs as $pair) {
              $xy = Explode(':',$pair);
              $coords_arr[$h][$i]['x'] = $xy[0];
              $coords_arr[$h][$i]['y'] = $xy[1];
              $i++;
            }
          }
          for($j=0;$j<Count($segments);$j++) {
            foreach($coords_arr[$j] as $coord) {
              $points[$j] .= '<POINT x="'.$coord['x'].'" y="'.$coord['y'].'" />'."\n";          
            }
          }
          switch(strtolower($SHAPE['type'])) {
           case 'polygon':
           case 'circle':
             $arcxml .= "<POLYGON>\n";
             foreach($points as $segm_points)
                $arcxml .= "<RING>\n$segm_points</RING>\n";
             $arcxml .= "</POLYGON>\n"; break;
           case 'polyline':
             $arcxml .= "<POLYLINE>\n";
             foreach($points as $segm_points)
                $arcxml .= "<PATH>\n$segm_points</PATH>\n";
             $arcxml .= "</POLYLINE>\n"; break;
           case 'point':
             $arcxml .= "<MULTIPOINT>\n";
             foreach($points as $segm_points)
                $arcxml .= "\n$segm_points\n";
             $arcxml .= "</MULTIPOINT>\n"; break;
           default: break;
          }
          $SHAPE['distance'] = $this->parse['neighbours'] ? '1' : (is_numeric($SHAPE['distance'])?$SHAPE['distance']:'0');
          $SHAPE['distance'] = str_replace('.',$this->DecimalSeparator,$SHAPE['distance']);
          if($SHAPE['distance'] || $this->parse['neighbours']) {
            $arcxml .= '<BUFFER units="meters" distance="'.$SHAPE['distance'].'">'."\n";
            $arcxml .= '  <TARGETLAYER id="'.$this->parse['from']['tables'][0].'" />'."\n";
            $arcxml .= '</BUFFER>'."\n";      
          }
  
        }
        $arcxml .= '</SPATIALFILTER>'."\n";
      }
      
      $arcxml .= '</SPATIALQUERY>'."\n";
      $arcxml .= '</GET_FEATURES></REQUEST></ARCXML>'."\n";
  
      $this->arcxml = $arcxml;

      //ORDER BY
      $this->parse['orderby']['fields'] = Split(',[ ]*', $this->parse['orderby']['text']);
      foreach($this->parse['orderby']['fields'] as $key=>$val) {
        if (Eregi('(.*)[ ]*(desc)$',Trim($val), $parse)) {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($parse[1]), 'desc'=>1);
        } elseif (Eregi('(.*)[ ]*(asc)$',Trim($val), $parse)) {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($parse[1]), 'desc'=>0);
        } else {
          $this->parse['orderby']['fields'][$key] = array('name'=>Trim($val));
        }
      }
      if ($this->parse['orderby']['fields'][0]['name']) {
        $order_by_name = $this->parse['orderby']['fields'][0]['name'];
        $order_by_desc = $this->parse['orderby']['fields'][0]['desc'];
        $met = $this->met ? $this->met : $this->metadata($this->parse['from']['tables'][0]);
      }
      
    }
    else {
      $this->num_rows = -1;
      $this->arcxml = $arcxml = $Query_String;
    }
//      $arcxml = mb_convert_encoding($arcxml, "UTF-8", "ISO-8859-2");
//      print_r($arcxml);
//       print_r(HtmlEntities($arcxml));
//       die();
    $ok = $this->msobj->query($arcxml, $order_by_name, $met[$order_by_name]['phptype'], $met[$order_by_name]['len']);
//  print_r($this->msobj->result);
//  die(print_r('end'));
//     die($ok);
    if (!$ok)
      ;
//        $this->halt('XML Error'); //Is in ARCIMS connector msobj
    elseif ($GLOBALS["PROPERTIES_DEBUG"]["SHOW_SQL"])
      $this->halt('DEBUG output', false);

    if (Count($this->msobj->result)) {
      reset($this->msobj->result);

      $this->Row = 0;
      $this->Record = array();

      //ORDER BY - first column only
  		if ($this->parse['orderby']['fields']) {
  		  if ($order_by_desc):
          if ($met[$order_by_name]['phptype'] == 'string') {
    			  if ($this->CzechSort == "windows-1250"):
              uksort($this->msobj->result, Compare_Czech_1250_Desc);
    			  elseif ($this->CzechSort == "iso-8859-2"):
      			  uksort($this->msobj->result, Compare_Czech_ISO_8859_2_Desc);
    				else:
              krsort($this->msobj->result);
    			  endif;
          } else {
            krsort($this->msobj->result);
          }
  			else:
          if ($met[$order_by_name]['phptype'] == 'string') {
    			  if ($this->CzechSort == "windows-1250"):
      			  uksort($this->msobj->result, Compare_Czech_1250);
    			  elseif ($this->CzechSort == "iso-8859-2"):
      			  uksort($this->msobj->result, Compare_Czech_ISO_8859_2);
    				else:
              ksort($this->msobj->result);
    			  endif;
          } else {
            ksort($this->msobj->result);
          }
  			endif;
  		}
  		Reset($this->msobj->result);

      return 1;

    } else
      return 1;
  }
  
  function seek($pos) {
    if ($this->Row != $pos) {
      Reset($this->msobj->result);
      $this->Row=0;
      for(; $this->Row<$pos; ) {
        $this->next_record();
      }
    }
  }

  function next_record() {
    if (!$this->Row++ && $this->num_rows()) {
      $this->Record = Current($this->msobj->result);
      $ok = 1;
    } else {
      if (Next($this->msobj->result)) {
        $this->Record = Current($this->msobj->result);
        $ok = 1;
      } else {
        $this->Record = array();
        $ok = 0;
      }
    }
    if($this->parse['from']['tables'][0]) { //tono - huge delay when not set (TODO!)
      $ffields = $this->metadata($this->parse['from']['tables'][0], 'float_fields');
      foreach ($ffields as $val) {
        $this->Record[$val] = Str_Replace(',', '.', $this->Record[$val]);
      }
    }
    return $ok;
  }

  function num_rows() {
    if ($this->num_rows == -1)
      $this->num_rows = Count($this->msobj->result);
    return $this->num_rows;
  }

  function metadata($table, $type='default') {
    $table = StrToUpper($table);
    if (!isset($this->cache['sinfo'])) {
      $this->cache['sinfo']= $this->msobj->service_info($this->Database, $table);
//      print_r($this->cache['sinfo']);
    }
    if (!isset($this->cache['metadata'][$table])) {
      if (Is_array($this->cache['sinfo'][$table]['fields'])) {
        reset($this->cache['sinfo'][$table]['fields']);
        $met = array();
        foreach($this->cache['sinfo'][$table]['fields'] as $val) {
          $u_name = StrToUpper($val['name']);
          switch ($u_name) {
            case 'SHAPE.AREA': $u_name = '_SHAPE_AREA_'; break;
            case 'SHAPE.LEN': $u_name = '_SHAPE_LEN_'; break;
          }
          $sde_prefix = '';
          if (Ereg('^(.*\.)([^.]*)$', $val['name'], $parse)) {
            $u_name = $parse[2];
            $sde_prefix = $parse[1];
          }
          $name = $u_name;
          $float = false;
          $orig_name = false;
          switch ($val['type']) {
            case -98: $type = '_shape_';  $phptype='string'; break; //shape fields
            case -99: $type = '_id_';     $phptype='integer'; $orig_name=$name; $name='_ID_'; break; //row_id type fields
            case   4: $type = 'int';      $phptype='integer'; break; //integer type fields
            case   5: $type = 'smallint'; $phptype='integer'; break; //small integer type fields
            case   6: $type = 'float';  $phptype='double';  break; //double type fields
            case   8: $type = 'double'; $phptype='double';  break; //double type fields
            case  12: $type = 'string'; $phptype='string';  break; //string type fields
            case  91: $type = 'date';   $phptype='string';  break; //date type fields
            case  56: $type = 'unknown'; $phptype='string'; break; //unknown type fields
          }
          if ($phptype == 'double') $met['float_fields'][] = $name;
          $met[$name]['table'] = $this->cache['sinfo'][$table]['id'];
          $met[$name]['name'] = $name;
          if ($sde_prefix) $met[$name]['sde_prefix'] = $sde_prefix;
          $met[$name]['type'] = $type;
          $met[$name]['phptype'] = $phptype;
          $met[$name]['len'] = Round($val['size']);
          $met[$name]['precision'] = Round($val['precision']);
          
          if($orig_name) {
            $met[$orig_name] = $met[$name];
            $met[$orig_name]['name'] = $orig_name;
          }
        }
        $this->cache['metadata'][$table] = $met;
      } else {
        $this->cache['metadata'][$table] = array();
      }
    }
    switch ($type) {
      case 'float_fields':
        $ret = $this->cache['metadata'][$table]['float_fields'];
        if (!$ret) $ret = array();
      break;
      default:
        $ret = $this->cache['metadata'][$table];
        unset($ret['float_fields']);
      break;
    }
    return $ret;
  }

  function halt($msg, $error=true) {
    if ($GLOBALS["Debug"]["arcims"] || $GLOBALS["PROPERTIES_DEBUG"]["SHOW_SQL"]) {
      if ($this->ShowError || !$error):
        $this->msobj->halt($msg, true, $error);
      endif;
    }
    if ($error && $this->Error_Die) die();
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $res = $date;
	  else:
       $res = $empty;
    endif;
    return $res;

  }

  function str2dbdate ($date, $empty="")
  {
    if ($date):
      $res = $date;
	  else:
      $res = $empty;
    endif;
    return $res;
  }

  function dbdate2date ($date, $empty="")
  {
    $time = false;
    if ($date) {
      $tok = Explode('-',$this->dbdate2str($date));
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    }
    return $time;
  }

}
?>
