<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_arcgisserver.inc,v 1.2 2008/03/06 13:17:02 tono Exp $'.'$Name:  $';exit;}; /* HEADER */
require_once($GLOBALS["TMAPY_LIB"]."/ms/ArcGISServer.inc");
require_once ($GLOBALS["TMAPY_LIB"].'/db/db_mapmain.inc');
include_once(FileUp2(".admin/functions_compare.inc"));

class DB_Sql_ArcGISServer extends DB_Sql_MapMain {
  var $LargeRequestLimit = 1000;
  var $CzechSort=false;

  function DB_Sql_ArcGISServer ($data=false) {
    if(isSet($this->server)) {
      $this->msobj = new MS_ArcGISServer(get_object_vars($this));
      switch (strtoupper($this->msobj->InternalCharsetSet)) {
        case 'ISO-8859-2':
          $this->CzechSort = "iso-8859-2";
        break;
        case 'WINDOWS-1250':
        case 'CP1250':
          $this->CzechSort = "windows-1250";
        break;
      }
    }
  }
  
//   function setMSObj($msobj=false) {
//     if(is_object($msobj) && get_class($msobj)=='MS_ArcGISServer') $this->msobj = $msobj;
//     else $this->msobj = new MS_ArcGISServer(get_object_vars($this));
//     switch (strtoupper($this->msobj->InternalCharsetSet)) {
//       case 'ISO-8859-2':
//         $this->CzechSort = "iso-8859-2";
//       break;
//       case 'WINDOWS-1250':
//       case 'CP1250':
//         $this->CzechSort = "windows-1250";
//       break;
//     }
//   }
  
  function connect() {
    return $this->msobj->SoapClient?true:false;
  }

  function query($Query_String) {
//     echo "$Query_String\n";
//     print_r($_POST);
    //explode SELECTs
    Eregi('SELECT ([^ ]+) FROM ([^ ]*) (.*)', $Query_String, $parse);
    if (preg_match("/SELECT [^ ]+ FROM [^ ]+/",$parse[3])) {
      if(!Eregi('.*([ ]*SELECT [^ ]+ FROM ([^ ]*) (.*))(\),[-0-9.]+\))$', $parse[3], $sub_parse))
          Eregi('.*([ ]*SELECT [^ ]+ FROM [^ ]* .*)[)][^)]*$', $parse[3], $sub_parse);
      $this->query($sub_parse[1]);
      if($this->parse['select']['shape']) {
        $coords = array();
//         foreach($this->msobj->result as $feature) {
//           $coords[] = Trim($feature['_SHAPE_COORDS_']);
//         }
//         $result['_SHAPE_COORDS_'] = Implode('&',$coords);
        $this->next_record();
        $found_feature = $this->Record;
        if($found_feature) {
          $found_feature['_SHAPE_COORDS_'] = str_replace(array(' ',','),array('|',':'),Trim($found_feature['_SHAPE_COORDS_']));
          $replacement = 'TMS_SHAPE_TYPE='.$found_feature['_SHAPE_TYPE_'].' AND TMS_SHAPE_COORDS='.$found_feature['_SHAPE_COORDS_'];
          $found_id = $found_feature['_ID_'];
        }
        else return 1;
      }
      if($replacement) {
        $Query_String = Str_Replace($sub_parse[1],$replacement,$parse[0]);
      }
    }
    //--  
  
    $this->Query_String = $Query_String;

    $this->PrepareParams($Query_String);

    //Table
    $this->AGSParams['LayerID'] = $this->msobj->getLayerIndexByLayerName($this->parse['from']['tables'][0]);

    //Fields
    if ($this->parse['select']['all']) $this->AGSParams['Subfields'] = false;
    else $this->AGSParams['Subfields'] = Implode(',',$this->parse['select']['fields']);

    $this->AGSParams['GetShape'] = false;
    
//     if (!$this->AGSParams['GetShape'] && !$this->AGSParams['Subfields']) {
//       $met = $this->metadata($this->AGSParams['LayerID']);
//       $this->AGSParams['Subfields'] = array();
//       foreach ($met as $fld) {
//         switch ($fld['agstype']) {
//           case 'esriFieldTypeGeometry':
//           break;
//           default:
//             if ($fld['agsname'] && !preg_match('/^shape_(length|area)/i', $fld['agsname']))
//               $this->AGSParams['Subfields'][] = $fld['agsname'];
//           break;
//         }
//       }
//       $this->AGSParams['Subfields'] = Implode(',',$this->AGSParams['Subfields']);
//     }
    
    //ORDER by
    if ($this->parse['orderby']['fields']) {
      $this->AGSParams['OrderBy'] = $this->parse['orderby']['fields'];
    }

    if($this->parse['select_shape']) {
      $this->AGSParams['SpatialFilter'] = array(
        'SearchOrder'=>'esriSearchOrderSpatial',
        'SpatialRel'=>'esriSpatialRelIntersects'
      );
      
      $sh_type = strtolower($this->parse['select_shape']['type']);
      switch($sh_type) {
        case 'point':
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal('PointN',array(
            'X'=>(double)$this->parse['select_shape']['coords'][0],
            'Y'=>(double)$this->parse['select_shape']['coords'][1],
          ));          
         break;
        case 'bbox':
          list($minx,$miny,$maxx,$maxy) = Explode(',',$this->parse['select_shape']['coords']);
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal('EnvelopeN',array(
            'XMin'=>(double)$minx,
            'YMin'=>(double)$miny,
            'XMax'=>(double)$maxx,
            'YMax'=>(double)$maxy,
          ));     
          break;  
        case 'polygon':
        case 'circle':
        case 'polyline':        
          if($sh_type=='polyline') {
            $shape_name = 'Polyline';
            $segment_name = 'Path';
          }
          else {
            $shape_name = 'Polygon';
            $segment_name = 'Ring';
          }
        
          $segments = Explode('&',$this->parse['select_shape']['coords']);
          $coords_arr = array();
          for($h=0;$h<Count($segments);$h++) {
            $coords_pairs = Explode('|',$segments[$h]);
            $i=0;
            foreach($coords_pairs as $pair) {
              $xy = Explode(':',$pair);
              $coords_arr[$h][$i]['x'] = $xy[0];
              $coords_arr[$h][$i]['y'] = $xy[1];
              $i++;
            }
          }
          
          $rings = array();
          for($j=0;$j<Count($segments);$j++) {
            $points = array();
            foreach($coords_arr[$j] as $coord) {
              $points[] = $this->msobj->getSoapVal('PointN',array(
                'X'=>(double)$coord['x'],
                'Y'=>(double)$coord['y'],
              ));          
            }
            $rings[] = $this->msobj->getSoapVal($segment_name,array(
                          'PointArray'=>$this->msobj->getSoapVal('ArrayOfPoint',$points)
                        ));            
          }

          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal($shape_name.'N',array(
            $segment_name.'Array'=>$this->msobj->getSoapVal('ArrayOf'.$segment_name,$rings)
          ));

          break;
        default: break;
      }
      
      if($this->parse['neighbours']) {
        if(is_array($found_feature['SHAPE'][$segment_name.'Array'][$segment_name]) &&
              Count($found_feature['SHAPE'][$segment_name.'Array'][$segment_name])>1) {
           
          $f_shape = $found_feature['SHAPE'][$segment_name.'Array'][$segment_name];
          $rings = array();
          for($i=0;$i<Count($f_shape);$i++) {
            $coords_arr = $f_shape[$i]['PointArray']['Point'];
            $points = array();
            foreach($coords_arr as $coord) {
              $points[] = $this->msobj->getSoapVal('PointN',array(
                'X'=>(double)$coord['X'],
                'Y'=>(double)$coord['Y'],
              ));          
            }
            $rings[] = $this->msobj->getSoapVal($segment_name,array(
                          'PointArray'=>$this->msobj->getSoapVal('ArrayOfPoint',$points)
                        ));            
          }
          
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal($shape_name.'N',array(
            $segment_name.'Array'=>$this->msobj->getSoapVal('ArrayOf'.$segment_name,$rings)
          ));
                    
        }
       
        $this->AGSParams['SpatialFilter']['WhereClause'] = $this->met['_ID_']['agsname'].' NOT IN ('.$found_id.')';
      }

      $request = array(
        'method'=>'QueryFeatureData',
        'params'=>array(
          'MapName'=>$this->msobj->encodeString($this->msobj->getMapName()),
          'LayerID'=>$this->AGSParams['LayerID'],
          'QueryFilter'=>$this->msobj->getSoapVal('SpatialFilter',$this->AGSParams['SpatialFilter'])
        )
      );         
    }
    //Where
    elseif ($this->parse['from']['rest']) {
      if (preg_match('/WHERE (.*)/i', $this->parse['from']['rest'], $match)) {
        //_ID_ with OR condition is NOT supported (always AND)
        if (preg_match('/[ ,]*_ID_[ =]*/',$match[1])) $_id_=true;
        $match[1] = preg_replace('/([ ,]*)FID([ ,=]*)/', '$1_ID_$2',$match[1]);
        if (preg_match('/(_ID_[ ]*(IN|=)[ (]*([0-9,]+)[)]*)/i',$match[1], $match2)) {
          $this->AGSParams['WhereClause'] = trim(preg_replace('/(AND|OR){0,1}[ ]*'.escapeshellcmd($match2[0]).'[ ]*(AND|OR){0,1}[ ]*/i','', $match[1]));
          $this->AGSParams['FIDArray'] = Explode(',', $match2[3]);
          if ($_id_) foreach ($this->AGSParams['FIDArray'] as $k=>$v) $this->AGSParams['FIDArray'][$k] = $this->AGSParams['FIDArray']-1;
        } else {
          $this->AGSParams['WhereClause'] = $match[1];
        }
        //Case insensitive for text
        $this->AGSParams['WhereClause'] = preg_replace('/(OR|AND)/i',"\$1\n", $this->AGSParams['WhereClause']);
        $this->AGSParams['WhereClause'] = preg_replace('/(\w+)[ ]*(like|=)[ ]*([\"\']+.*[\"\']+)/i','Upper($1) $2 Upper($3)', $this->AGSParams['WhereClause']);
        $this->AGSParams['WhereClause'] = preg_replace("/\n/i",'', $this->AGSParams['WhereClause']);
      }
    
      $this->AGSParams['WhereClause'] = preg_replace("/ ORDER BY .*/i",'', $this->AGSParams['WhereClause']);
      
      $request = array(
        'method'=>'QueryFeatureData',
        'params'=>array(
          'MapName'=>$this->msobj->encodeString($this->msobj->getMapName()),
          'LayerID'=>$this->AGSParams['LayerID'],
          'QueryFilter'=>$this->msobj->getSoapVal('QueryFilter',array(
            'SubFields'=>$this->AGSParams['Subfields'],
            'WhereClause'=>$this->AGSParams['WhereClause']
          ))
        )
      );      
    }
    
    if ($this->AGSParams['FIDArray']) {
      $request['params']['QueryFilter']->value['FIDSet'] = $this->msobj->getSoapVal('FIDSet',array(
        'FIDArray'=>$this->msobj->getSoapVal('FIDArray',$this->AGSParams['FIDArray'])
      ));
      if (Count($this->AGSParams['FIDArray']) > $this->LargeRequestLimit || $this->AGSParams['GetShape']) $request['method'] = 'QueryFeatureIDs';
    } else {
      $requestCount = $request;
      $requestCount['method'] = 'QueryFeatureCount';
      $result = $this->msobj->soapCall($requestCount);
      if ($result['Result'] > $this->LargeRequestLimit || $this->AGSParams['GetShape']) $request['method'] = 'QueryFeatureIDs';
    }

    $id = $this->msobj->query($request);
    
    unset($this->OrderByRecordSet);
    if ($this->AGSParams['OrderBy']) {
      $result = array();
      while ($this->next_record()) {
        $result[$this->Record[$this->AGSParams['OrderBy'][0]['name']]] = $this->Record;
      }
      $this->OrderByRecordSet=&$result;
      $this->SortResult(&$this->OrderByRecordSet);
      $id = true;
    }
    $this->Row = 0;
    
    //print_R($this->msobj->SoapResult);die();
    return $id;
  }
  
  function seek($pos) {
    if (isset($this->OrderByRecordSet)) {
      $this->Row = 0;
      reset($this->OrderByRecordSet);
      for (;$pos>($this->Row+1); $this->Row++) {
        next($this->OrderByRecordSet);
      }
      $this->Record = Current($this->OrderByRecordSet);
    } else {
      $result = $this->msobj->seek($pos);
      $this->Row = $this->msobj->Row;
      $this->Record = $this->msobj->Record;
    }
    return $result;
  }

  function next_record() {
    if (isset($this->OrderByRecordSet)) {
      if ($this->Row++==0) $this->Record = Current($this->OrderByRecordSet);
      else $this->Record = Next($this->OrderByRecordSet);
      $result = Is_array($this->Record)?true:false;
    } else {
      $result = $this->msobj->next_record();
      $this->Record = $this->msobj->Record;
      $this->Row = $this->msobj->Row;
    }
    return $result;
  }

  function num_rows() {
    return $this->msobj->num_rows();
  }

  function metadata($table, $params=false) {
    $this->met = $this->msobj->metadata($table, $params);
    $met = &$this->met;
    return $met; 
  }

  function dbdate2str ($date, $removenull=false, $empty="&nbsp;") {
    if ($date):
      $res = $date;
	  else:
       $res = $empty;
    endif;
    return $res;
  }

  function str2dbdate ($date, $empty="")
  {
    if ($date):
      $res = $date;
	  else:
      $res = $empty;
    endif;
    return $res;
  }

  function dbdate2date ($date, $empty="")
  {
    $time = false;
    if ($date) {
      $tok = Explode('-',$this->dbdate2str($date));
      $time = MkTime(0,0,0,$tok[1],$tok[0],$tok[2]);
    }
    return $time;
  }

}
?>
