<?php
class AGServiceObjMain{

  var $properties = array();
  var $config = array();
  var $http_vars = array();
  var $ags_params = array();
  var $form_schema = array();
  var $table_schema = array();
  var $warnings = array();
  var $output_charset = '';
  var $input_charset = '';
  var $db = false;
  var $db_metadata = array();
  var $use_tms = false;  // zda bude z TMS Interface ziskavat souradnice
  var $debug = false; //zobrazi SQL a v sekundach dobu jeho vykonani
  var $pagepos = 0;
  var $pagesize = 0;
  var $maxnumrows = 0;  //maximalni pocet vracenych zaznamu

  /**
  * Konstruktor
  */       
  function AGServiceObjMain($properties, $http_vars, $ags_params){
   
    /// vlastnosti a nastaveni
    $this->properties = $properties;
    $this->config = $properties['AG_SERVICES'];
    $this->http_vars = $http_vars;
    $this->ags_params = $ags_params;
    
    /// aby nechybeli dulezite parametry
    if(!$properties['AGENDA_ID']) $this->showError('In properties.inc missing parameter AGENDA_ID', 1);
    if(!$properties['AGENDA_TABLE']) $this->showError('In properties.inc missing parameter AGENDA_TABLE', 2);
    
    /// nacteni form schematu
    $form_file = '.admin/form_schema_ags.inc';
    if(!File_exists($form_file)) $this->showError("Missing $form_file", 3);
    require($form_file);
    $this->form_schema = $FORM_SCHEMA;
    
    /// nacteni table schematu
    $table_file = '.admin/table_schema_ags.inc';
    if(!File_exists($table_file)) $this->showError("Missing $table_file", 4);
    require($table_file);
    $this->table_schema = $TABLE_SCHEMA;
    
    /// nastavi vstupni, vystupni typ formatovani dat
    switch ($properties['DEFAULT_LANG']){
     case 'utf-8'  : $this->input_charset  = 'UTF-8'; break;
     case 'unicode': $this->input_charset  = 'UNICODE'; break;
     case 'cz_win' : $this->input_charset  = 'WINDOWS-1250'; break;
     case 'cz_iso' :
     default       : $this->input_charset  = 'ISO-8859-2';
    }
    $this->output_charset = $this->config['OUTPUT_CHARSET']?$this->config['OUTPUT_CHARSET']:$this->input_charset;
    
    /// vytvoreni DB konektoru a ziskani metadat k hlavni tabulce
    $db_obj_name = $properties["DB_NAME"]?$properties["DB_NAME"]:"DB_DEFAULT";
    $this->db = new $db_obj_name;
    $this->db_metadata = $this->db->metadata($properties['AGENDA_TABLE']);

    if($this->config['TMS_PROJECT'] && $this->config['TMS_PROJECT'] && $this->config['TMS_INTERFACE_FIELD']){ 
      $this->use_tms = true;
      $this->config['TMS_DB_FIELD'] = $this->config['TMS_DB_FIELD']?$this->config['TMS_DB_FIELD']:$this->config['TMS_INTERFACE_FIELD'];
    }
    
    ///pokud prijde parametr s chybou, tak ji zobraz
    if($this->ags_params['showerror']) $this->ShowError($this->ags_params['showerror'], 5);
    
    $this->debug = $this->http_vars['debug']?$this->http_vars['debug']:false; 

    $this->pagepos = (integer) $this->http_vars['pagepos']?$this->http_vars['pagepos']:0; 
    $this->pagesize = (integer) $this->http_vars['pagesize']?$this->http_vars['pagesize']:0;
    
    if($this->http_vars['maxnumrows'] || $this->config['MAXNUMROWS']){
      $this->maxnumrows = $this->http_vars['maxnumrows']?$this->http_vars['maxnumrows']:$this->config['MAXNUMROWS']; 
    } 
      
  }
  

  /**
  * Vraci informace o sluzbe   
  */
  function getInfo(){
    echo "Info";
  }
  

  /**
  * Vraci definici Formulare
  * defaultne vraci pro vyhledavani    
  */       
  function getForm($type = 'form'){
    echo "Form";
  }
  
  
  /**
  * Vraci Tabulku s daty
  */       
  function getTable(){
    echo "Table";
  }
  
  
  /**
  * Vraci data
  */
  function getData(){
   
    //print_r($this->http_vars);
    //print_r($this->db_metadata);
 
    $arr_data = array();
    
    require_once(FileUp2(".admin/brow_.inc"));
    
    $sql = Table(array("return_sql"=>true, "appendwhere"=>$this->ags_params['appendwhere']));

    //die($sql);
    //$this->ShowError($sql);
    
    $this->db->ShowError = $this->debug ? true : false;
    $GLOBALS["Debug"]["sql"] = true;
    
    $start = time();
    
    if($this->pagesize && isset($this->pagepos))
      $this->db->query_page($sql, $this->pagepos, $this->pagesize);
    else
      $this->db->query($sql);
      
    $end = time();
    
    if($this->debug){
      echo "<div>$sql</div>\nTime:".($end-$start)."s<br>\n<br>\n";
      flush();
    }
    
    if(!$this->db->Query_ID) $this->ShowError('Bad SQL !', 20);
    
    $arr_data['numrows'] = (integer) $this->db->num_rows();
    
    $tms_ids = array();
    $numrows = 0;
        
    while($this->db->next_record()){
      
      $row = array();
      $numrows++;
      
      foreach($this->table_schema['schema'] as $ts){

        $row[] = RunFceInString($ts['field'], &$this->db->Record);
      }
      
      if($this->config['DB_FIELD_X'] && $this->config['DB_FIELD_Y'] && !$this->use_tms)
        $row['ext'] = array('minx'=>(integer)$this->db->Record[ $this->config['DB_FIELD_X'] ], 
                            'miny'=>(integer)$this->db->Record[ $this->config['DB_FIELD_Y'] ], 
                            'maxx'=>(integer)$this->db->Record[ $this->config['DB_FIELD_X'] ], 
                            'maxy'=>(integer)$this->db->Record[ $this->config['DB_FIELD_Y'] ]);

      $value4tms = $this->db->Record[ $this->config['TMS_DB_FIELD'] ];
      
      if($this->use_tms && $value4tms){
        $tms_ids[] = $value4tms;
        $row[$this->config['TMS_DB_FIELD']] = $value4tms;
      }
      
      $arr_data['records'][] = $row;
      
      ///pokud je nastaven maximalni pocet radku a ten je mensi nez celkovy pocet radku a bylo jej dosazeno
      if($this->maxnumrows && $this->maxnumrows<$arr_data['numrows'] && $this->maxnumrows==$numrows){
        $this->warningAdd(array('found'=>(integer) $arr_data['numrows'],'returned'=>(integer) $this->maxnumrows), 100);
        $arr_data['numrows'] = $numrows;
        break;
      }  
    }

    if($this->use_tms && $tms_ids) $this->getTMSCoords($tms_ids, $arr_data['records']);

    /// pokud je nejaky warning, tak jej prida k datum
    if($this->warnings) $arr_data['warnings'] = $this->warnings;
   
    return $arr_data;
  }
  
  
  /**
   *  Z TMS Interface zjisti X a Y a prida je k datum 
   */
  function getTMSCoords($tms_ids, &$arr_data){
    
    $tms_project_dir = GetAgendaPath($this->config['TMS_PROJECT'], false);

    $temp_dir = getcwd();
    chdir($tms_project_dir);
    
    $GLOBALS['Theme'] = $this->config['TMS_INTERFACE_THEME'];
    $GLOBALS['Field'] = $this->config['TMS_INTERFACE_FIELD'];
    $GLOBALS['Values'] = implode(',',$tms_ids);
    //die($GLOBALS['Values']);

    include_once(Fileup2(".admin/interface_prepare.inc"));
    
    $interface->RunInterface();
    
    if($interface->error) $this->ShowError('TMS Interface error - '.$interface->errorName, 30);
    if($interface->alert) $this->ShowError('TMS Interface alert - '.$interface->alertName, 35);
    
    //print_r($interface->records);
    
    /// priradi nalezene souradnice k zaznamu z databaze
    foreach($arr_data as $k => $rec){
      
      ///ted nalezt ve vracenych datech z interface souradnice
      foreach($interface->records as $iarr){
         if($iarr[$this->config['TMS_INTERFACE_FIELD']] == $rec[$this->config['TMS_DB_FIELD']])
            $arr_data[$k]['ext'] = $iarr['ext'];
      }
      
    }
    
         
    chdir($temp_dir);
    return true;
  }               
  
  
  /**
  * Vraci chybove hlaseni
  */
  function showError($errmsg, $errno=0){
    die($errmsg.'('.$errno.')');
  }
  
  /**
   *
   */
  function warningAdd($warmsg, $warno=0){
    $this->warnings[$warno] = $warmsg;
  }      
  
  /**
  * Prida do form/table schema meta informace z properties.inc
  */       
  function addMetadataToForm (&$form){
  
    $form['name'] = $this->properties['AGENDA_NAME'];
    $form['ident'] = $this->properties['AGENDA_IDENT'];
    $form['description'] = $this->properties['AGENDA_DESCRIPTION']?$this->properties['AGENDA_DESCRIPTION']:'';
    $form['id'] = $this->properties['AGENDA_ID'];
    $form['table'] = $this->properties['AGENDA_TABLE'];
    $form['charset'] = $this->output_charset;
    $form['use_tms'] = $this->use_tms;
    $form['pagepos'] = $this->pagepos;
    $form['pagesize'] = $this->pagesize;
 
  }
        
  
  /**
   * Odstrani z retezce entry
   */      
  function NoEnter($str){
    return str_replace(chr(13),"",str_replace(chr(10)," ",$str));
  }
  
  
  /**
   * Pred vystupem prekoduje retezec na pozadovane kodovani
   */      
  function CharsetEncode($str){
    if(is_string($str)){
      if($this->input_charset != $this->output_charset) 
        $str = iconv($this->input_charset, $this->output_charset, $str);
      if($str==false) $this->showError('ICONV can\'t convert from '.$this->input_charset.' to '.$this->output_charset, 40);
    }  
    return $str;  
  } 
   
}

?>
