<?php
require_once ('main.inc');

class AGServiceObjJSON extends AGServiceObjMain
{

   function getInfo(){
     
     $info_schema = $this->config;
     
     $this->addMetadataToForm($info_schema);
     
     echo $this->CharsetEncode($this->FormatJSObject($info_schema, 'AGInfo'));
     
   }


   function getForm($type = 'filter'){
      
      $type = $this->http_vars['type']?$this->http_vars['type']:$type;
      
      $this->addMetadataToForm($this->form_schema);
      
      echo $this->CharsetEncode($this->FormatJSObject($this->form_schema, 'AGForm'));
      
   }


   function getTable(){

      $this->addMetadataToForm($this->table_schema);
      
      $records = $this->getData();
      
      $data = array_merge($this->table_schema, $records);
      
      echo $this->CharsetEncode($this->FormatJSObject($data, 'AGTable'));
   }
   
  
  
   function showError($errmsg, $errno=0){
     $arr = array('message'=>$errmsg, 'number'=>$errno);
     die($this->CharsetEncode($this->FormatJSObject($arr, 'AGError',0,1)));
   }


   
  /**
   * Tato fce() je prebrana od TOKRa z TMS -> lehce upravena TONO (content_only parameter)
   * \\matej2\www-data\demo2003.tmapserver.cz\tms\.admin\map_ifrm.inc    
   */     
//   function FormatJSObject($arr,$name,$level=0,$novar=0) {
//     $nl=!$level?"\n":'';
//     $nl="\n";
//     if (!$level)
//       $ret .= ($novar?'':"var ").Str_Repeat($nl?' ':'',$level).$name."={";
//     else
//       $ret .= $nl.Str_Repeat($nl?' ':'',$level-1).$name.":{";
//     if ($arr) {
//       foreach($arr as $key=>$val) {
//         switch (getType($val)) {
//           case 'boolean':
//             $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:".($val?'1':'0').",";
//           break;
//           case 'string':
//             $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:";
//             if (Preg_match("/'/", $val))
//               $ret .= '"'.$val.'",';
//             else
//               $ret .= "'$val',";
//           break;
//           case 'array':
//             $ret .= $this->FormatJSObject($val,$key,$level+1);
//           break;
//           default:
//             $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:$val,";
//           break;
//         }
//       }
//       $ret = RTrim($ret,',');
//     }
//     if (!$level) 
//       $ret .= $nl.Str_Repeat($nl?' ':'',$level)."};\n";
//     else 
//       $ret .= $nl.Str_Repeat($nl?' ':'',$level-1)."},";
//     return $ret;
//   }
  
  function FormatJSObject($arr,$name="var1",$level=0,$novar=0,$content_only=false) {
    $nl=!$level?"\n":'';
    $nl="\n";
    if (!$level) {
      if($content_only) $ret .= "{";
      else $ret .= ($novar?'':"var ").Str_Repeat($nl?' ':'',$level).$name."={";
    }
    else
      $ret .= $nl.Str_Repeat($nl?' ':'',$level-1).$name.":{";
    if ($arr) {
      foreach($arr as $key=>$val) {
        $key = strtr($key,'-','_');
        switch (getType($val)) {
          case 'boolean':
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:".($val?'1':'0').",";
          break;
          case 'string':
            if(!$val) $val = "''";
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:";
            if (Preg_match("/'/", $val))
              $ret .= '"'.$val.'",';
            else
              $ret .= "'$val',";
          break;
          case 'array':
            $ret .= $this->FormatJSObject($val,$key,$level+1,0);
          break;
          default:
            if(!$val) $val = "''"; 
            $ret .= $nl.Str_Repeat($nl?' ':'',$level)."$key:$val,";
          break;
        }
      }
      $ret = RTrim($ret,',');
    }
    if (!$level) 
      $ret .= $nl.Str_Repeat($nl?' ':'',$level)."};\n";
    else 
      $ret .= $nl.Str_Repeat($nl?' ':'',$level-1)."},";
    return $ret;
  }  


}

?>
