
CREATE TABLE security_group
(
  id serial NOT NULL,
  type_group int2,
  description text,
  public_group char(1) DEFAULT '1',
  name varchar(100),
  parent_group_id int2 DEFAULT '0',
  last_date date,
  last_time varchar,
  last_user_id int4,
  owner_id int4,
  CONSTRAINT security_group_pkey PRIMARY KEY (id)
);
---------------------------------------------------------

CREATE TABLE security_user
(
  id serial NOT NULL,
  group_id int4,
  login_name varchar(16) NOT NULL,
  fname varchar(30) NOT NULL,
  lname varchar(30) NOT NULL,
  title_1 varchar(20),
  title_2 varchar(20),
  email varchar(60),
  phone varchar(20),
  passwd varchar(100),
  note text,
  active char(1) DEFAULT '1',
  public_user char(1) DEFAULT '1',
  order_by_index int2 DEFAULT 5,
  short varchar(5),
  adresa varchar(200),
  zamestnani varchar(100),
  phone_2 varchar(20),
  mobil varchar(20),
  fax varchar(20),
  budova varchar(10),
  mistnost varchar(10),
  signature varchar(100),
  last_date date,
  last_time varchar,
  last_user_id int4,
  owner_id int4,
  CONSTRAINT security_user_pkey PRIMARY KEY (id)
);

CREATE INDEX security_user_group_id
  ON security_user
  USING btree
  (group_id);

CREATE INDEX security_user_login_name
  ON security_user
  USING btree
  (login_name);

CREATE INDEX security_user_active
  ON security_user
  USING btree
  (active);
--------------------------------------------------------

CREATE TABLE security_u_g
(
  id serial NOT NULL,
  u_id int4 NOT NULL,
  g_id int4 NOT NULL,
  CONSTRAINT security_u_g_pkey PRIMARY KEY (id)
);

CREATE INDEX security_u_g_g_id
  ON security_u_g
  USING btree
  (g_id);

CREATE INDEX security_u_g_u_id
  ON security_u_g
  USING btree
  (u_id);
--------------------------------------------------------

INSERT INTO security_user (group_id,login_name,passwd,fname,lname,active,public_user) 
	VALUES (1, 'tmapy', '0afcf8fbd664c9b6275f716719de4663', 'tmapy', 'tmapy', '1', '0');
INSERT INTO security_user (group_id,login_name,passwd,fname,lname,active,public_user) 
	VALUES (1, 'kaan', 'f82e5a98b9b7185172a5bd755e64d58c', 'Karel', 'Anto', '1', '0');

INSERT INTO security_group (type_group,description,public_group,name) VALUES (1, 'T-MAPY', '1', 'T-MAPY');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Pstup vude', '0', 'access_all');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Me vechno', '0', 'upload_admin');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Me vkldat a upravovat pouze vlastn', '0', 'upload_user');

INSERT INTO security_u_g (u_id,g_id) VALUES (1, 2);
INSERT INTO security_u_g (u_id,g_id) VALUES (2, 2);
INSERT INTO security_u_g (u_id,g_id) VALUES (3, 2);
