--DROP SEQUENCE seq_security_group_id;
CREATE SEQUENCE seq_security_group_id;
--DROP TABLE security_group;
CREATE TABLE security_group
(
  id decimal NOT NULL,
  type_group decimal,
  description varchar2(1000),
  public_group char(1) DEFAULT '1',
  name varchar2(100),
  parent_group_id decimal DEFAULT 0,
  last_date date,
  last_time varchar2(8),
  last_user_id decimal,
  owner_id decimal,
  PRIMARY KEY (id)
);
CREATE OR REPLACE TRIGGER security_group_sequence BEFORE INSERT ON security_group 
REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW
BEGIN
  SELECT seq_security_group_id.NEXTVAL INTO :NEW.id FROM DUAL;
END security_group_sequence;

---------------------------------------------------------

--DROP SEQUENCE seq_security_user_id;
CREATE SEQUENCE seq_security_user_id;
--DROP TABLE security_user;
CREATE TABLE security_user
(
  id decimal NOT NULL,
  group_id decimal,
  login_name varchar2(16) NOT NULL,
  fname varchar2(30) NOT NULL,
  lname varchar2(30) NOT NULL,
  title_1 varchar2(20),
  title_2 varchar2(20),
  email varchar2(60),
  phone varchar2(20),
  passwd varchar2(100),
  note varchar2(4000),
  active char(1) DEFAULT '1',
  public_user char(1) DEFAULT '1',
  order_by_index decimal DEFAULT 5,
  short varchar2(5),
  adresa varchar2(200),
  zamestnani varchar2(100),
  phone_2 varchar2(20),
  mobil varchar2(20),
  fax varchar2(20),
  budova varchar2(10),
  mistnost varchar2(10),
  signature varchar2(100),
  last_date date,
  last_time varchar2(8),
  last_user_id decimal,
  owner_id decimal,
  PRIMARY KEY (id)
);
CREATE INDEX security_user_group_id ON security_user (group_id);
CREATE INDEX security_user_login_name ON security_user (login_name);
CREATE INDEX security_user_active ON security_user (active);

CREATE OR REPLACE TRIGGER security_user_sequence BEFORE INSERT ON security_user 
REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW
BEGIN
  SELECT seq_security_user_id.NEXTVAL INTO :NEW.id FROM DUAL;
END security_user_sequence;

--------------------------------------------------------

--DROP SEQUENCE seq_security_u_g_id;
CREATE SEQUENCE seq_security_u_g_id;
--DROP TABLE security_u_g;
CREATE TABLE security_u_g
(
  id decimal NOT NULL,
  u_id decimal NOT NULL,
  g_id decimal NOT NULL,
  PRIMARY KEY (id)
);

CREATE INDEX security_u_g_u_id ON security_u_g (u_id);
CREATE INDEX security_u_g_g_id ON security_u_g (g_id);

CREATE OR REPLACE TRIGGER security_u_g_sequence BEFORE INSERT ON security_u_g 
REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW
BEGIN
  SELECT seq_security_u_g_id.NEXTVAL INTO :NEW.id FROM DUAL;
END security_u_g_sequence;
--------------------------------------------------------

INSERT INTO security_user (group_id,login_name,passwd,fname,lname,active,public_user) 
	VALUES (1, 'tmapy', '0afcf8fbd664c9b6275f716719de4663', 'tmapy', 'tmapy', '1', '0');
INSERT INTO security_user (group_id,login_name,passwd,fname,lname,active,public_user) 
	VALUES (1, 'kaan', 'f82e5a98b9b7185172a5bd755e64d58c', 'Karel', 'Anto', '1', '0');

INSERT INTO security_group (type_group,description,public_group,name) VALUES (1, 'T-MAPY', '1', 'T-MAPY');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Pstup vude', '0', 'access_all');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Me vechno', '0', 'upload_admin');
INSERT INTO security_group (type_group,description,public_group,name) VALUES (3, 'Me vkldat a upravovat pouze vlastn', '0', 'upload_user');

INSERT INTO security_u_g (u_id,g_id) VALUES (1, 2);
INSERT INTO security_u_g (u_id,g_id) VALUES (2, 2);
INSERT INTO security_u_g (u_id,g_id) VALUES (3, 2);
