<?php
/*
Trida pro vyhledani session_id pomoci IP adresy. Pouzito pro rozhrani RADNICE VERA. 

V tmapy_config.inc musi byt

//SessionINFO for RADVERA interface
if (file_exists($GLOBALS["TMAPY_DIR"]."/.config/settings/session_info.inc")) {
  require_once($GLOBALS["TMAPY_DIR"]."/.config/settings/session_info.inc");
  new twist_session_info();
}

*/
 
class twist_session_info {
  
  function twist_session_info($remote_addr=0) {
    session_save_path($this->getSessionDir($remote_addr));
  }
  
  function findSessionIdByRemoteAddr($remote_addr) {
    $dir = $this->getSessionDir($remote_addr);
    $session_id = false;
    if (Is_dir($dir)) {
      $d = dir($dir);
      $files = array();
      while (false !== ($f = $d->read())) {
        $fn = $dir.'/'.$f;
        if (Is_File($fn)) $files[fileatime($fn)]=$f;
      }
      $d->close();
      krsort($files);
      $session_id = Substr(Current($files),-32); 
    }
    return $session_id;
  }
  
  //Private
  
  function getSessionDir($remote_addr=0) {
    static $cache, $path;
    if (!$cache) {
      $path = session_save_path();
    }
    if (!$cache[$remote_addr]) { 
      $dir = $path.'/'.BaseName($GLOBALS["TMAPY_DIR"]);
      if (!Is_dir($dir)) mkdir($dir);
      $dir .= '/'.($remote_addr?$remote_addr:$_SERVER['REMOTE_ADDR']);
      if (!Is_dir($dir)) mkdir($dir);
      $cache[$remote_addr] = $dir;
    }
    return $cache[$remote_addr];
  }
  
}

?>
