<?php

function CheckPath($str) {
  if (StrPos($str,"..")!=false || StrPos($str,"/")!=false || StrPos($str,"\\")!=false) return true;
  else return false;
}

function CheckFileWorkspace($file) {
  $f = realpath($file);
  if (!$f) return false;
  if (function_exists("apache_lookup_uri")) {
    $obj = apache_lookup_uri($file); 
    $f = $obj->filename;
    if (StrCmp($f,$GLOBALS["TMAPY_DIR"])<0) return false;
  }
  return true;
}

function CheckInputVariables() {
  reset($GLOBALS["TMAPY_VARIABLES"]);
  while(list($key,$val) = each($GLOBALS["TMAPY_VARIABLES"])) {
    switch ($val) {
      case 2:
        if (IsSet($GLOBALS[$key])) UnSet($GLOBALS[$key]);
      break;
      case 3:
        if (IsSet($GLOBALS[$key])) {
          if (Is_Array($GLOBALS[$key])) UnSet($GLOBALS[$key]);
        }
      break;
      case 5:
        if (IsSet($GLOBALS[$key])) {
          if (CheckPath($GLOBALS[$key])) UnSet($GLOBALS[$key]);
        }
      break;
      case 6:
        if (IsSet($GLOBALS[$key])) {
          if (!CheckFileWorkspace($GLOBALS[$key])) UnSet($GLOBALS[$key]);
        }
      break;
    }
  }
}

function CheckInputVariable($key,$val) {
  switch($GLOBALS["TMAPY_VARIABLES"][$key]) {
    case 1:
    case 2:
      return false;
    break;
    case 3:
      if (Is_Array($val)) return false;
    break;
    case 5:
      if (CheckPath($val)) return false;
    break;
    case 6:
      if (!CheckFileWorkspace($val)) return false;
    break;
  }
  return true; 
}
?>
