<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: tree_.inc,v 1.4 2002/08/26 07:51:02 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

function ShowTree ($file, $params=false) { 

  //expandall  bool  rozbali vsechny nody
             
  
  $script       = $SCRIPT_NAME;
  
  $img_expand   = FileUp2("images/editor/tree_expand.gif",true);
  $img_collapse = FileUp2("images/editor/tree_collapse.gif",true);
  $img_line     = FileUp2("images/editor/tree_vertline.gif",true);  
  $img_split	  = FileUp2("images/editor/tree_split.gif",true);
  $img_end      = FileUp2("images/editor/tree_end.gif",true);
  $img_leaf     = FileUp2("images/editor/tree_leaf.gif",true);
  $img_spc      = FileUp2("images/editor/tree_space.gif",true);
  
  /*********************************************/
  /*  Read text file with tree structure       */
  /*********************************************/
  
  /*********************************************/
  /* read file to $tree array                  */
  /* tree[x][0] -> tree level                  */
  /* tree[x][1] -> item text                   */
  /* tree[x][2] -> item link                   */
  /* tree[x][3] -> link target                 */
  /* tree[x][4] -> last item in subtree        */
  /*********************************************/

  $maxlevel=0;
  $cnt=0;

  if (Is_Array($file)):
    $tree = $file;
    for ($i=0; $i<count($tree); $i++) {
      if ($tree[$i][0] > $maxlevel) $maxlevel=$tree[$i][0];
    }      
  else:  
    $fd = fopen($file, "r");
    if ($fd==0) die("treemenu.inc : ".$GLOBALS["RESOURCE_STRING"]["tree_file"].$treefile);
    while ($buffer = fgets($fd, 4096)) 
    {
      $tree[$cnt][0]=strspn($buffer,".");
      $tmp=rtrim(substr($buffer,$tree[$cnt][0]));
      $node=explode("|",$tmp); 
      $tree[$cnt][1]=$node[0];
      $tree[$cnt][2]=$node[1];
      $tree[$cnt][3]=$node[2];
      $tree[$cnt][4]=0;
      if ($tree[$cnt][0] > $maxlevel) $maxlevel=$tree[$cnt][0];    
      $cnt++;
    }
    fclose($fd);
  
  endif;

  $i=0;
  for ($i=0; $i<count($tree); $i++) {
     $expand[$i]=0;
     $visible[$i]=0;
     $levels[$i]=0;
  }
  
  /*********************************************/
  /*  Get Node numbers to expand               */
  /*********************************************/

  global $te;
  
  if ($te):
    $explevels = explode("|",$te);
  else:
    $expandall = Is_Array($params) && $params["expandall"];
    if ($expandall):
      $explevels = array();
      for ($i=0; $i<count($tree); $i++) {
        if (($maxlevel > $tree[$i][0])&&($tree[$i][0] < $tree[$i+1][0]))
         $explevels[] = $i;
      }
    endif;
  endif;
  
  $i=0;
  while($i<count($explevels))
  {
    $expand[$explevels[$i]]=1;
    $i++;
  }
  
  /*********************************************/
  /*  Find last nodes of subtrees              */
  /*********************************************/
  
  $lastlevel=$maxlevel;
  for ($i=count($tree)-1; $i>=0; $i--)
  {
     if ( $tree[$i][0] < $lastlevel )
     {
       for ($j=$tree[$i][0]+1; $j <= $maxlevel; $j++)
       {
          $levels[$j]=0;
       }
     }
     if ( $levels[$tree[$i][0]]==0 )
     {
       $levels[$tree[$i][0]]=1;
       $tree[$i][4]=1;
     }
     else
       $tree[$i][4]=0;
     $lastlevel=$tree[$i][0];  
  }
  
//  include(FileUp2(".admin/functions.inc"));
//  ShowArray($tree);
  
  /*********************************************/
  /*  Determine visible nodes                  */
  /*********************************************/
  
  $lastlevel = 0;
  $visible[0]=1;   // root is always visible
  for ($i=0; $i<count($explevels); $i++)
  {
    $n=$explevels[$i];
    if ( ($visible[$n]==1) && ($expand[$n]==1) )
    {
       $j=$n+1;
       while ( $tree[$j][0] > $tree[$n][0] )
       {
         if ($tree[$j][0]==$tree[$n][0]+1) $visible[$j]=1;     
         $j++;
       }
       if ($lastlevel < $tree[$n][0]) $lastlevel = $tree[$n][0]; 
    }
  }
  
  /*********************************************/
  /*  Output nicely formatted tree             */
  /*********************************************/
  
  for ($i=0; $i<$maxlevel; $i++) $levels[$i]=1;

  $maxlevel++;
  $class = "class=\"tree\"";
  $width2 = "width=\"16\"";
  
  echo "<table $class cellspacing=0 cellpadding=0 border=0 width=\"".($maxlevel*16+100)."\" cols=".($maxlevel+3).">\n";
  echo "<tr>";
  for ($i=0; $i<$lastlevel+2; $i++) echo "<td $class $width2></td>";
  echo "<td $class></td></tr>\n";
  $cnt=0;
  while ($cnt<count($tree))
  {
    if ($visible[$cnt])
    {
      /****************************************/
      /* start new row                        */
      /****************************************/      
      echo "<tr>";
      
      $width = ($tree[$cnt][0] < ($lastlevel+1))?$width2:"";

      /****************************************/
      /* vertical lines from higher levels    */
      /****************************************/
      $i=0;
      while ($i<$tree[$cnt][0]-1) 
      {
        if ($levels[$i]==1)
            echo "<td $class $width><img src=\"".$img_line."\"></td>";
        else
            echo "<td $class $width><img src=\"".$img_spc."\"></td>";
        $i++;
      }
      
      /****************************************/
      /* corner at end of subtree or t-split  */
      /****************************************/         
      if ($tree[$cnt][4]==1) 
      {
        if ($cnt) 
          echo "<td $class $width><img src=\"".$img_end."\"></td>";
        else
          echo "<td $class $width><img src=\"".$img_spc."\"></td>";
        $levels[$tree[$cnt][0]-1]=0;
      }
      else
      {
        echo "<td $class $width><img src=\"".$img_split."\"></td>";                  
        $levels[$tree[$cnt][0]-1]=1;    
      } 
      
      /********************************************/
      /* Node (with subtree) or Leaf (no subtree) */
      /********************************************/
      if ($tree[$cnt+1][0]>$tree[$cnt][0])
      {
        
        /****************************************/
        /* Create expand/collapse parameters    */
        /****************************************/
        $i=0; $tearams="?te=";
        while($i<count($expand))
        {
          if ( ($expand[$i]==1) && ($cnt!=$i) || ($expand[$i]==0 && $cnt==$i))
          {
            $tearams=$tearams.$i;
            $tearams=$tearams."|";
          }
          $i++;
        }
               
        if ($expand[$cnt]==0)
            echo "<td $class $width><a id=\"$cnt\" $class href=\"".$script.$tearams."\"><img src=\"".$img_expand."\" border=no></a></td>";
        else
            echo "<td $class $width><a id=\"$cnt\" $class href=\"".$script.$tearams."\"><img src=\"".$img_collapse."\" border=no></a></td>";         
      }
      else
      {
        /*************************/
        /* Tree Leaf             */
        /*************************/

        echo "<td $class $width><img src=\"".$img_leaf."\"></td>";         
      }
      
      /****************************************/
      /* output item text                     */
      /****************************************/
      if ($tree[$cnt][2]=="")
          echo "<td $class $width colspan=".($maxlevel-$tree[$cnt][0]).">&nbsp;".$tree[$cnt][1]."</td>";
      else
          echo "<td $class $width colspan=".($maxlevel-$tree[$cnt][0]).">&nbsp;<a id=\"$cnt\" $class href=\"".$tree[$cnt][2]."\" target=\"".$tree[$cnt][3]."\">".$tree[$cnt][1]."</a></td>";
          
      /****************************************/
      /* end row                              */
      /****************************************/
              
      echo "</tr>\n";      
    }
    $cnt++;    
  }
  echo "</table>\n";
}

?>
