<?php
//Promnn $table_params je pole obsahujc nsledujc kle

/*
db                       str, DB_DEFAULT Nazev tridy pro DB
sql                      str           SQL command
caption                                hodnota pro caption
nocaption                bool          vpis bez titulku
setvars                  bool, false   Nastaven promnnch
unsetvars                bool, array   Smazn obsahu promnnch na konci vpisu tabulky
                                       parametrem muze byt i hash s except, ketre obsahuje nazvy promennych,
                                       ktere maji zustat
align                    bool, true    align=100%
maxnumrows               int,  100     maximalni pocet radku pro nestrankovany vypis

border                   int, 0        border
cellspacing              int, 0        cellspacing
cellpadding              int, 3        cellpadding
schema                   array, false  table_schema pro zobrazeni tabulky
callback                 str           nazev call back 

nullvalue                str, &nbsp; 
*/

include_once($GLOBALS["TMAPY_LIB"]."/tableex.inc");

function Table_Common($table_params) {
  $sql = $table_params["sql"];
  
  $db_name = $table_params["db"]?$table_params["db"]:"DB_DEFAULT";
  if (Is_Object($db_name)) {
    $q = $db_name;
  } else {
    $q = new $db_name;
  }
  
  $q->query($sql);

  $t = new TableEx;
  $t->name = $table_params["tablename"];  
  $t->class = "text/css";  
  $t->heading = isset($table_params["headings"])?$table_params["headings"]:true; 
  $t->check = false;
  $t->null = $table_params["nullvalue"]?$table_params["nullvalue"]:"&nbsp;";
  
  $t->border = $table_params["border"]?$table_params["border"]:0;
  $t->cellspacing = $table_params["cellspacing"]?$table_params["cellspacing"]:0;
  $t->cellpadding = $table_params["cellpadding"]?$table_params["cellpadding"]:3;

  $t->pagesize = $table_params["maxnumrows"]?$table_params["maxnumrows"]:100;
  $t->setvars = $table_params["setvars"]?true:false;
  $t->unsetvars = $table_params["unsetvars"]?$table_params["unsetvars"]:false;
  $t->align = isset($table_params["align"])?$table_params["align"]:true;
  $t->callback = $table_params["callback"]?$table_params["callback"]:ChangeClass;
 
  $t->schema = $table_params["schema"]?$table_params["schema"]:false;
  if ($t->schema) {
    include_once(FileUp2(".admin/functions.inc"));
  }

  
  if ((!isset($table_params["nocaption"])||(!$table_params["nocaption"]))&&$table_params["caption"]):
    echo "<span class=\"caption\">".$table_params["caption"]."</span>\n";
  endif;
  
  $rowcount = $t->show_result_page($q, 0, $t->pagesize, "brow");
}

?>
