<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: progressbar_obj.inc,v 1.3 2008/03/14 14:50:44 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

/**
 * PROGRESS BAR
 */
class Progress_Bar
{
  
  var $ident = '1'; //unikatni identifikator tohoto progressbaru (kdyz jich je vic na strance, tak aby se odlisili)
  var $max_count = 100;  //hodnota pro 100%
  var $style_arr = array();  //pole stylu


  /**
   * konstruktor tridy
   * nastavuje default style a maximalni hodnotu pro 100%   
   */
  function Progress_Bar($max_count=0,$ident=false){
    
    $this->ident = $ident ? $ident : rand(0,255);

    if($max_count) $this->max_count = $max_count;
    
    $this->style_arr['progress_cover_div_'.$this->ident] = array(
      'width'=>'500px',
    );
    $this->style_arr['progress_main_div_'.$this->ident] = array(
      'border'=>'1px solid gray',
      'width'=>'400px',
      'height'=>'15px',
      'padding'=>'2px',
      'float'=>'left',
      'font-size'=>'5px',
    );
    $this->style_arr['progress_div_'.$this->ident] = array(
      'background-color'=>'red',
      'width'=>'0px',
      'height'=>'100%',
    );
    $this->style_arr['progress_text_div_'.$this->ident] = array(
      'font-size'=>'12px',
      'text-align'=>'left',
      'color' => 'red',
    );
  
  }
  

  /**
   * vyresetuje procenta
   */
  function reset($max_count=false){
    $this->now_count = 0;
    if($max_count) $this->max_count = $max_count;      
  }


  /**
   * nastavi vlastni styl
   */
  function setStyle($style_arr){
    
    foreach($style_arr as $field => $s_arr){
      foreach($s_arr as $s_name => $s_value){
        $this->style_arr[$field.'_'.$this->ident][$s_name] = $s_value;
      }
    } 
    
    //$this->style_arr['progress_cover_div']['width'] = $this->style_arr['progress_main_div']['width'];

  }
  
  
  /**
   * z definice stylu vytvori styl v HTML
   */
  function createStyle(){

    $style = "\n".'<style type="text/css">';
    $style.= "\n<!--\n";
    
    foreach($this->style_arr as $field => $s_arr){
      $style.= '#'.$field."{\n";
      foreach($s_arr as $s_name => $s_value){
        $style.= "$s_name:$s_value;\n";
      }
      $style.= "}\n";
    }
    
    $style.= "-->\n";
    $style.= "</style>\n";
    
    return $style;
  } 
  
  
  
  /**
   * zobrazi progress bar se stylem
   */
  function show(){
    echo $this->CreateStyle();
    echo '<div id="progress_cover_div_'.$this->ident.'"><div id="progress_main_div_'.$this->ident.'"><div id="progress_div_'.$this->ident.'"></div></div><div id="progress_text_div_'.$this->ident.'">&nbsp;</div></div>'."\n";
    $this->Progress();    
    flush();
  }
  
  
  
  /**
   * provede narust progress baru
   */
  function progress($now_count=0){
    
    $this->now_count = $now_count;

    $percent = floor((100/$this->max_count) * $this->now_count);
    
    if($this->percent != $percent || $percent==0){
      $this->percent = $percent;
      $text = $this->percent.'&nbsp;%';  
      echo "<script>document.getElementById('progress_div_".$this->ident."').style.width='".$this->percent."%';document.getElementById('progress_text_div_".$this->ident."').innerHTML='".$text."'</script>\n"; 
      flush();
    }
      
  }
  


  /**
   * co ma udelat az bude zkonci cyklus narustu
   */
  function progressEnd($end_text='HOTOVO', $color = '', $hidden=false){
    echo "<script>document.getElementById('progress_text_div_".$this->ident."').innerHTML='".$end_text."'</script>\n"; 
    if ($hidden)
      echo "<script>document.getElementById('progress_cover_div_".$this->ident."').style.display='none'</script>\n";
    if ($color)
      echo "<script>document.getElementById('progress_div_".$this->ident."').style.backgroundColor='$color'</script>\n";
    flush();
  
  }
  
  
}
?>
