<?php

class MIME_MAIL{

  var $parts;
  var $to;
  var $reply;
  var $from;
  var $headers;
  var $subject;
  var $body;
  
  /*
  * void mime_mail()
  * konstruktor tdy
  */
  
  function mime_mail() {
    $this->parts = array();
    $this->to = "";
    $this->reply = "";
    $this->from = "";
    $this->subject = "";
    $this->body = "";
    $this->headers = "";
  }

  /*
  * void add_attachment(string message, [string name], [string ctype])
  * vlo plohu do objektu zprvy
  */
  
  function add_attachment($message, $name = "", $ctype = "application/octet-stream", $charset = false, $encode = "base64") {
    $this->parts[] = array (
       "message" => $message,
       "name" => $name,
       "ctype" => $ctype,
       "charset" => $charset,
       "encode" => $encode,
       );
  }

  /*
  * void build_message(array part=
  * vytvoen sti vcedln zprvy
  */
  
  function build_message($part) {
    $message = $part['message'];
    $encoding = $part['encode'];
    if($encoding == 'base64'){
      $message = chunk_split(base64_encode($message));
    }  
    return "Content-Type: ".$part[ "ctype"].($part[ "name"]? "; name = \"".$part[ "name"]."\"" : "").($part[ "charset"]? "; charset = \"".$part[ "charset"]."\"" : "").
           "\nContent-Transfer-Encoding: $encoding\n\n$message\n";
  }
  
  /*
  * void build_multipart()
  * vytv vcedlnou zprvu
  */
  
  function build_multipart() {
    $boundary = "b".md5(uniqid(time()));
    $multipart = "Content-Type: multipart/mixed; boundary = $boundary\n\nThis is a MIME encoded message.\n\n--$boundary";
    for($i = count($this->parts)-1; $i >= 0; $i--){
      $multipart .= "\n".$this->build_message($this->parts[$i])."--$boundary";
    }
    return $multipart.= "--\n";
  }

  /*
  * string get_mail()
  * vrac vytvoenou zprvu
  */
  
  function get_mail($complete = true) {
  
    $mime = "";
  
    if (!empty($this->from)) $mime .= "From: ".$this->from. "\n";
    if (!empty($this->reply)) $mime .= "Reply-to: ".$this->reply. "\n";
    if (!empty($this->headers)) $mime .= $this->headers. "\n";
  
    if ($complete) {
      if (!empty($this->to)) {
        $mime .= "To: $this->to\n";
      }
      if (!empty($this->subject)) {
        $mime .= "Subject: $this->subject\n";
      }
    }
    
    ///pridani tela zpravy ve formatu text
    if (!empty($this->body)){
      $this->body = $this->Win2Iso($this->body);
      $this->add_attachment($this->body, "", "text/plain", "ISO-8859-2", "7bit");
    }
    
    ///vytvori vlastni email
    $mime .= "MIME-Version: 1.0\n".$this->build_multipart();
  
    return $mime;
  }

  
  /*
  * void send()
  * odesl zprvu(posledn funkce tdy, kterou je poteba zavolat)
  */
  
  function send() {

    ///aby byl SUBJECT cesky
    if (!empty($this->subject)) {
      $this->subject = $this->Win2Iso($this->subject);
      $this->subject = '=?iso-8859-2?B?'.base64_encode($this->subject).'?=';
    }
    
    ///hlavicky a telo zpravy
    $mime = $this->get_mail(false);
    
    
    //vlastni odeslani mailu
    return mail($this->to, $this->subject, "", $mime);
  }


  function Win2Iso($str){
    return StrTr($str,"","");
  }

}; // konec tdy

?>
