<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: lang_func.inc,v 1.3 2008/04/15 07:32:49 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

// funkce pro konverzi ISO LATIN 2 - Windows 1250 - ASCII
//
// function ConvertLang ( retezec, druh )
//   kde druh:
//        0 - nekonvertovat
//        1 - z ISO 8859-2 na Win1250
//        2 - z Win1250 na ISO 8859-2
//        3 - z ISO 8859-2 na ASCII
//        4 - z Win1250 na ASCII

if (!function_exists("ConvertLang")) {
  $win1250 = "";
  $isolatin2 = "";
  $czwin = "ş؊ݎ";
  $ascii = "aaaaccdeeeilnnoooorstuuuuyzzAAAACCDEEEILLNNOOOORSTUUUUYZZ";

  function IsoToWin($str){
    global $isolatin2,$win1250;
		return StrTr($str,$isolatin2,$win1250);
	}

	function WinToIso($str){
    global $isolatin2,$win1250;
		return StrTr($str,$win1250,$isolatin2);
	}

  function WinToAsci($str){
    global $czwin,$ascii;
		return StrTr($str,$czwin,$ascii);
	}

  function IsoToAsci($str){
		return WinToAsci(IsoToWin($str));
	}

  function ConvertLang($str, $druh) {
    switch ($druh) {
      case 0:
        break;
      case 1:
        $str = IsoToWin($str);
        break;
      case 2:
        $str = WinToIso($str);
        break;
      case 3:
        $str = IsoToAsci($str);
        break;
      case 4:
        $str = WinToAsci($str);
        break;
    }
    return $str;
  }

  function TranslateToUnicodeEntities($str, $charset='UTF-8') {
    $unicode = '';        
    $values = array();
    $lookingFor = 1;
    $str = iconv($charset, 'UTF-8', $str);
    for ($i = 0; $i < strlen($str); $i++ ) {
      $thisValue = ord( $str[ $i ] );
      if ($thisValue < 128) $unicode .= $str[$i];
      else {
        if (count($values) == 0) $lookingFor = ($thisValue < 224) ? 2 : 3;
        $values[] = $thisValue;
        if ( count( $values ) == $lookingFor ) {
          $number = ( $lookingFor == 3 ) ?
              ( ( $values[0] % 16 ) * 4096 ) + ( ( $values[1] % 64 ) * 64 ) + ( $values[2] % 64 ):
          	( ( $values[0] % 32 ) * 64 ) + ( $values[1] % 64 );
          $unicode .= '&#'.$number.';';
          $values = array();
          $lookingFor = 1;
        } // if
      } // if
    } // for
    return $unicode;
  }

}

?>
