<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: hitcounter_obj.inc,v 1.1 2009/10/27 09:12:37 lumo Exp $'.'$Name:  $';exit;}; /* HEADER */

/**
 * pocitadlo pristupu
 *
 * POUZITI:
 *   $counter = new Hit_Counter();
 *   $counter->insert();
 */

class Hit_Counter {
  /*
   * kvuli zalozeni tabulky - PostgreSQL,MSSQL,MYSQL,ORACLE
   */
  var $db_type = 'PostreSQL';
  /*
   * objekt DB pro praci s databazi
   */
  var $db = null;

  /*
   * konstruktor
   */
  function Hit_Counter($db_type = null, $db_name = null) {
    if ($db_name) {
      $this->db = new $db_name;
    }
    else {
      include_once(FileUp2('.admin/db/db_default.inc'));
      $this->db = new DB_DEFAULT;
    }
    if ($db_type) {
      $this->db_type = $db_type;
    }
    else {
      $parent = get_parent_class($this->db);
      if (eregi('oci', $parent)) {
        $this->db_type = 'ORACLE';
      }
      elseif (eregi('psql', $parent)) {
        $this->db_type = 'PostgreSQL';
      }
      elseif (eregi('mssql', $parent)) {
        $this->db_type = 'MSSQL';
      }
      elseif (eregi('mysql', $parent)) {
        $this->db_type = 'MYSQL';
      }
    }
  }

  /*
   * vypsani pocitadla do stranky
   *
   * @param string popisek nad cislem
   */
  function insert($title = '') {
    // kde ho vypiseme, tam chceme i pocitat
    $this->hit();
    // nacteme datum od
    $this->db->query('SELECT min(hitdate) AS mindate FROM hitcounter');
    $this->db->next_record();
    $min = $this->db->dbdate2str($this->db->Record['MINDATE']);
    // vypiseme
    print '<script type="text/javascript">';
    include(FileUp2('.admin/el/hitcounter.js'));
    print '</script>'."\n";
    print '<span class="hitcounter">'.($title ? $title : $GLOBALS['RESOURCE_STRING']['hit_count']).
          ' '.strtolower($GLOBALS['RESOURCE_STRING']['from1']).' '.$min.
          '</span><br>';
    print '<div id="hitcounter">';
    $GLOBALS['command'] = 'get';
    include(FileUp2('.admin/hitcounter_process.php'));
    print '</div>'."\n";
    print '<script type="text/javascript">hc_nacti_hodnotu();</script>';
  }

  /*
   * nacteni poctu pristupu
   */
  function getCount() {
    $this->db->query('SELECT sum(hit) AS hitcount FROM hitcounter');
    $this->db->next_record();

    return ($this->db->Record['HITCOUNT'] ? $this->db->Record['HITCOUNT'] : 0);
  }

  /*
   * zapsani poctu pristupu
   */
   function hit() {
     $ip = $_SERVER['REMOTE_ADDR'];
     $sql = 'SELECT id,tmstamp FROM hitcounter WHERE ip=\''.$ip.'\' '
          . 'AND hitdate=\''.$this->db->str2dbdate(date('d.m.Y')).'\'';
     $this->db->query($sql);
     $this->db->next_record();
     // jen pokud je starsi 5 minut
     if ($this->db->Record['TMSTAMP'] < time() - (60 * 5)) {
       if (!$this->db->Record['ID']) {
         $sql = 'INSERT INTO hitcounter (ip, hitdate, hit, tmstamp) '
              . 'VALUES(\''.$ip.'\', \''.$this->db->str2dbdate(date('d.m.Y')).'\','
              . '1, '.time().')';
       }
       else {
         $sql = 'UPDATE hitcounter SET '
              . 'hit=hit+1,'
              . 'tmstamp='.time().' '
              . 'WHERE id='.$this->db->Record['ID'];
       }
       $this->db->query($sql);
     }
   }

   /*
    * vynulovani pristupu - vymazani vsech zaznamu
    */
   function init() {
     // TODO zachovat historii?
     $this->db->query('DROP TABLE hitcounter');
     // TODO oracle dodelat
     switch ($this->db_type) {
       case 'ORACLE':
         $create = 'CREATE TABLE hitcounter ('
                 . '  id integer NOT NULL, '
                 . '  ip varchar2(16) NOT NULL, '
                 . '  hitdate date, '
                 . '  hit integer, '
                 . '  tmstamp integer, '
                 . '  PRIMARY KEY (id)'
                 . ')';
         break;
       case 'MYSQL':
         $create = 'CREATE TABLE hitcounter ('
                 . '  id integer NOT NULL auto_increment, '
                 . '  ip varchar(16) NOT NULL, '
                 . '  hitdate date, '
                 . '  hit integer, '
                 . '  tmstamp integer, '
                 . '  PRIMARY KEY (id)'
                 . ')';
         break;
       case 'MSSQL':
         $create = 'CREATE TABLE hitcounter ('
                 . '  id IDENTITY(1,1) NOT NULL, '
                 . '  ip varchar(16) NOT NULL, '
                 . '  hitdate date, '
                 . '  hit integer, '
                 . '  tmstamp integer, '
                 . '  PRIMARY KEY (id)'
                 . ')';
         break;
       case 'PosgreSQL':
       default :
         $create = 'CREATE TABLE hitcounter ('
                 . '  id serial NOT NULL, '
                 . '  ip varchar(16) NOT NULL, '
                 . '  hitdate date, '
                 . '  hit integer, '
                 . '  tmstamp integer, '
                 . '  PRIMARY KEY (id)'
                 . ')';
         break;
     }
     $this->db->query($create);
     // je oracle - musime vytvorit sequenci a trigger
     if ($this->db_type == 'ORACLE') {
       $this->db->query('CREATE SEQUENCE seq_hitcounter_id START WITH 1 INCREMENT BY 1'); 
       $this->db->query('CREATE OR REPLACE TRIGGER hitcounter_trg '.
           'BEFORE INSERT ON hitcounter '.
           'FOR EACH ROW '.
           'BEGIN '.
           '  SELECT seq_hitcounter_id.NEXTVAL INTO :NEW.id FROM DUAL; '.
           'END;'
         ); 
     }
   }
}
