<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: functions_compare.inc,v 1.1 2005/02/01 07:47:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

function Convert_Czech($str, $cpfrom, $cpto, $unicode_entities=false) {
  $enc['iso-8859-2'] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
  $enc['windows-1250'] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
  if ($unicode_entities) {
    if ($cpfrom == 'iso-8859-2') $str = StrTr($str, $enc['iso-8859-2'], $enc['windows-1250']);
    $count = Strlen($str);
    $res = '';
    for ($i=0;$i<$count;$i++) {
      switch(Ord($str[$i])) {
        case(225)://
          $res.="&#225;";
        break;
        case(232)://
          $res.="&#269;";
        break;
        case(239)://""
          $res.="&#271;";
        break;
        case(233)://""
          $res.="&#233;";
        break;
        case(236)://""
          $res.="&#283;";
        break;
        case(237)://""
          $res.="&#237;";
        break;
        case(242)://""
          $res.="&#328;";
        break;
        case(243)://""
          $res.="&#243;";
        break;
        case(248)://""
          $res.="&#345;";
        break;
        case(154)://""
          $res.="&#353;";
        break;
        case(157)://""
          $res.="&#357;";
        break;
        case(250)://""
          $res.="&#250;";
        break;
        case(249)://""
          $res.="&#367;";
        break;
        case(253)://""
          $res.="&#253;";
        break;
        case(158)://""
          $res.="&#382;";
        break;
        case(193)://""
          $res.="&#193;";
        break;
        case(200)://""
          $res.="&#268;";
        break;
        case(207)://""
          $res.="&#270;";
        break;
        case(201)://""
          $res.="&#201;";
        break;
        case(204)://""
          $res.="&#282;";
        break;
        case(205)://""
          $res.="&#205;";
        break;
        case(210)://""
          $res.="&#327;";
        break;
        case(211)://""
          $res.="&#211;";
        break;
        case(216)://""
          $res.="&#344;";
        break;
        case(138)://""
          $res.="&#352;";
        break;
        case(141)://""
          $res.="&#356;";
        break;
        case(218)://""
          $res.="&#218;";
        break;
        case(217)://""
          $res.="&#366;";
        break;
        case(221)://""
          $res.="&#221;";
        break;
        case(142)://""
          $res.="&#381;";
        break;
        default:
          $res.=$str[$i];
        break;
     }
    }   
  } else {
    $res = StrTr($str, $enc[$cpfrom], $enc[$cpto]);
  }
  
  return $res;	
}

function Compare_Czech ($a, $b, $codepage="windows-1250") {
  if (StrCmp($a, $b) == 0) return 0;
  if (!$tr_from):
    static $tr_from;
    static $tr_to;
  if ($codepage == "iso-8859-2"):
    $tr_from = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
  else:
    $tr_from = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
  endif;
    $tr_to =   "1123456778ABCCDEFGHIJKKLMNOPQRSTTTUVWXXYZ"."1123456778ABCCDEFGHIJKKLMNOPQRSTTTUVWXXYZ";
  endif;
  //CH
//  $a1 = ERegi_Replace("CH", "H|", $a);
//  $b1 = ERegi_Replace("CH", "H|", $b);
  $a1 = Preg_Replace("/CH/i", "H|", $a);
  $b1 = Preg_Replace("/CH/i", "H|", $b);
  $a1 = StrTr($a1, $tr_from, $tr_to);	
  $b1 = StrTr($b1, $tr_from, $tr_to);
  return StrCmp($a1, $b1);	
} 

function Compare_Czech_1250 ($a, $b) {
  return Compare_Czech ($a, $b, "windows-1250");
} 

function Compare_Czech_1250_Desc ($b, $a) {
  return Compare_Czech ($a, $b, "windows-1250");
}  

function Compare_Czech_ISO_8859_2 ($a, $b) {
  return Compare_Czech ($a, $b, "iso-8859-2");
} 

function Compare_Czech_ISO_8859_2_Desc ($b, $a) {
  return Compare_Czech ($a, $b, "iso-8859-2");
}  

function ERegiCZ ($find, $str) {
  static $czarr = array ( 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|",
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|",
    ""=>"|", ""=>"|",
    ""=>"|", ""=>"|",
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|", 
    ""=>"|", ""=>"|"
 ); 
 reset($czarr);
 while (list($key, $val) = each($czarr)) {
   $find = Str_Replace($key, "(".$val.")", $find);
 }
 return ERegi($find, $str);
}
?>