<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: chart_pie.inc,v 1.1.1.1 2001/09/26 14:36:36 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Piechart extends Graph {
  var $segments = array();
  var $img_w = 100;
  var $img_h = 100;
  var $radius = 50;
  var $bgcolor;
  var $outline = true;

  function Piechart($rad,$bgcolor='') {
    $this->Graph ();
    $this->img_w = $rad*2;
    $this->img_h = $rad*2;
    $this->radius = $rad;
    if (!empty($bgcolor)) {
      $this->bgcolor = $bgcolor;
    }
    else {
      $this->bgcolor = new Chart_Color(0,0,255);
    }
  }

  function addSegment($val=0,$color) {
    $this->segments[$val]=$color;
  }

  function createImage() {
    $total = 0;
    reset($this->segments);
    while(list($key,$val)=each($this->segments)) {
      if ($key > 0) $total += $key;
    }

    $cx = floor($this->img_w/2);
    $cy = floor($this->img_h/2);

    #$kx = $this->img_w/$cnmax;
    #$ky = $this->img_h/(abs($max)+abs($min));

    $im = ImageCreate($this->img_w,$this->img_h);

    $blue = ImageColorAllocate($im,$this->linecolor->R, $this->linecolor->G, $this->linecolor->B);
    $white = ImageColorAllocate($im,255,255,255);
    $bgc = ImageColorAllocate($im,$this->bgcolor->R,$this->bgcolor->G,$this->bgcolor->B);

    ImageColorTransparent($im,$bgc);
    ImageFill($im,$cx,$cy,$bgc);
    ImageArc($im,$cx,$cy,$this->img_w,$this->img_h,0,360,$blue);
    ImageLine($im,$cx,$cy,$cx+$this->img_w,$cy,$blue);

    reset($this->segments);
    $prev = 0;
    $sm = 0;
    while(list($key,$val)=each($this->segments)) {
      if ($key <= 0) continue; 
      //  
      $percent = $key/$total*100;
      // 
      $angle = (360/100)*$percent;
      $sm += $angle;
      //   
      $rad = deg2rad($sm);
      $dx = ($this->radius) * cos($rad);
      $dy = ($this->radius) * sin($rad);
      ImageLine($im,$cx,$cy,$cx+$dx,$cy-$dy,$blue);
      $gamma = $rad - $prev;
      $delta = $prev + $gamma/2;
      $dxp = ($this->radius/2) * cos($delta);
      $dyp = ($this->radius/2) * sin($delta);
      $color = ImageColorAllocate($im,$val->R,$val->G,$val->B);
      ImageFill($im,$cx+$dxp,$cy-$dyp,$color);
      if (!$this->outline)
        ImageLine($im,$cx,$cy,$cx+$dx,$cy-$dy,$color);
      $prev = $rad;
    }
    if (!$this->outline)
      ImageArc($im,$cx,$cy,$this->img_w,$this->img_h,0,360,$bgc);
    else
      ImageArc($im,$cx,$cy,$this->img_w,$this->img_h,0,360,$blue);
    $this->image = $im;
    return $im;
  }
}
?>
