<?php
/**
 * PAREMETRY (nazev  default  moznosti  popis):
 * command      info        info/form/table     typ akce, kterou ma provezt
 * format       serialize   serialize/json      druh vystupniho formatu
 * appendwhere  null        string              navic podminka pro vyber dat
 * showerror    null        string              zobrazi automaticky chybu
*/ 

function AGService($ags_params=array()){

  require(FileUp2('.admin/properties.inc'));
  include_once(Fileup2(".admin/access_.inc"));

  if(!Access()) $ags_params['showerror'] = 'Access denied.';
  //print_r($GLOBALS["PROPERTIES_ACCESS"]);
  
  if(!is_array($PROPERTIES['AG_SERVICES']))
    die('Missing agenda service configuration in properties.inc');
  
  $http_vars = $GLOBALS['HTTP_GET_VARS']?$GLOBALS['HTTP_GET_VARS']:$GLOBALS['HTTP_POST_VARS'];  
    
  $command = $http_vars['command']?$http_vars['command']:($PROPERTIES['AG_SERVICES']['DEFAULT_COMMAND']?$PROPERTIES['AG_SERVICES']['DEFAULT_COMMAND']:'info');
  $command = strtolower($command);
  
  $format = $http_vars['format']?$http_vars['format']:($PROPERTIES['AG_SERVICES']['DEFAULT_FORMAT']?$PROPERTIES['AG_SERVICES']['DEFAULT_FORMAT']:'serialize');
  $format = strtolower($format);
  
  $file_format_obj = $GLOBALS["TMAPY_LIB"].'/ag_service/'.$format.'.inc';
  
  if (!File_exists($file_format_obj)) {
    die('Service object "'.$format.'" does not exist.');
  }
  
  require($file_format_obj);
  
  $fobj_name = 'AGServiceObj'.$format;
  
  $fobj = new $fobj_name($PROPERTIES, $http_vars, $ags_params);
  
  //print_r($fobj->config);
  
  switch($command){
    
    case 'info' : $fobj->getInfo(); break;
    case 'form' : $fobj->getForm(); break;
    case 'table': $fobj->getTable(); break;
    default     : $fobj->showError('Unknown command argument '.$command, 10);
  }
  
  flush();
}
?>
